/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.admin.web.operation;

import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRoleService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.SRoleuserService;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SRoleDTO;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.SRoleuserDTO;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.web.controller.BaseController;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class SRoleController
extends BaseController<SRoleDTO, SRoleService> {
    @Autowired
    private SRoleuserService sRoleuserService;

    @RequestMapping(value={"/api/s/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleDTO>> querySRoleAll(SRoleDTO vo) {
        List outputVo = ((SRoleService)this.getService()).queryListByPage((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/roles/notpage"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleDTO>> queryList(SRoleDTO vo) {
        List outputVo = ((SRoleService)this.getService()).queryList((Object)vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/role/{roleno}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SRoleDTO> queryByPk(@PathVariable(value="roleno") String roleno) {
        SRoleDTO inVo = new SRoleDTO();
        inVo.setRoleno(new String(roleno));
        SRoleDTO outputVo = (SRoleDTO)((SRoleService)this.getService()).queryByPk((Object)inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/role"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SRoleDTO inSRoleVo) {
        int outputVo = ((SRoleService)this.getService()).deleteByPk((Object)inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/role"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SRoleDTO inSRoleVo) {
        int outputVo = ((SRoleService)this.getService()).updateByPk((Object)inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/role"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSRole(@RequestBody SRoleDTO inSRoleVo) {
        int outputVo = ((SRoleService)this.getService()).insert((Object)inSRoleVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/api/s/roles/not/used"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleDTO>> qryNotSelectSRoleAll(SRoleuserDTO sRoleuserVO) {
        List outputVo = null;
        String actorNo = sRoleuserVO.getActorno();
        if (StringUtils.isBlank((CharSequence)actorNo)) {
            return this.getResponseData(null);
        }
        List<String> roleNos = this.getRoleNosByActorNo(actorNo);
        outputVo = Objects.nonNull(roleNos) && roleNos.size() > 0 ? ((SRoleService)this.getService()).queryAllFilterList(roleNos) : ((SRoleService)this.getService()).queryList((Object)new SRoleDTO());
        return this.getResponseData(outputVo);
    }

    private List<String> getRoleNosByActorNo(String actorNo) {
        SRoleuserDTO sRoleuserVO = new SRoleuserDTO();
        sRoleuserVO.setActorno(actorNo);
        List sRoleUserVOS = this.sRoleuserService.queryList((Object)sRoleuserVO);
        if (Objects.isNull(sRoleUserVOS) && sRoleUserVOS.size() == 0) {
            return null;
        }
        return sRoleUserVOS.stream().map(SRoleuserDTO::getRoleno).collect(Collectors.toList());
    }

    @RequestMapping(value={"/api/s/role/user/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SRoleDTO>> queryUserRoleListByPage(SRoleDTO vo) {
        List outputVo = ((SRoleService)this.getService()).queryUserRoleListByPage(vo);
        return this.getResponseData(outputVo);
    }
}

