/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.admin.web.ssm.web.filter;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.allintpaas.sdk.admin.facade.operation.dto.AuthInfoVO;
import com.irdstudio.allintpaas.sdk.admin.web.ssm.session.SessionManager;
import com.irdstudio.framework.beans.core.util.CookiesUtil;
import com.irdstudio.framework.beans.core.util.GsonUtils;
import com.irdstudio.framework.beans.core.util.MD5Util;
import com.irdstudio.framework.beans.core.util.StringUtil;
import com.irdstudio.framework.beans.core.util.URLUtil;
import com.irdstudio.framework.beans.core.vo.ResponseData;
import com.irdstudio.framework.beans.core.vo.UserInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class E4AFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(E4AFilter.class);
    private static String[] passedPaths = null;
    private SessionManager sessionManager;
    private String casServerLoginUrl = "";
    private boolean failRedirect = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        WebApplicationContext applicationcontext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        this.sessionManager = (SessionManager)applicationcontext.getBean("sessionManager", SessionManager.class);
        String urls = filterConfig.getInitParameter("allowUrl");
        if (StringUtils.isNotBlank((CharSequence)urls)) {
            passedPaths = urls.split(";");
        }
        this.casServerLoginUrl = filterConfig.getInitParameter("casServerLoginUrl");
        this.failRedirect = Boolean.parseBoolean(filterConfig.getInitParameter("failRedirect"));
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        if (this.casServerLoginUrl != null) {
            CookiesUtil.addCookie((HttpServletResponse)response, (String)"casserver", (String)this.casServerLoginUrl.replace("/login", ""), (int)-1);
        }
        String requestPath = request.getServletPath();
        AntPathMatcher matcher = new AntPathMatcher();
        if (passedPaths != null) {
            for (String passedPath : passedPaths) {
                boolean flag = matcher.match(passedPath, requestPath);
                if (!flag) continue;
                logger.info("sso client request path '" + requestPath + "'is matched,filter chain will be continued.");
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        AuthInfoVO authInfo = null;
        try {
            String sessionId = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssoclient");
            Long timestamp = StringUtil.String2Long((String)CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssottp"));
            String md5 = CookiesUtil.getCookieValue((HttpServletRequest)request, (String)"ssomd5");
            if (StringUtils.isBlank((CharSequence)sessionId)) {
                sessionId = request.getSession().getId();
            }
            authInfo = new AuthInfoVO();
            UserInfo userInfo = this.sessionManager.getLoginInfo(sessionId);
            if (userInfo != null && userInfo.getUserId() != null) {
                String jsonStr = JSONObject.toJSONString((Object)userInfo);
                String checkMd5 = MD5Util.getMD5ofStr((String)URLUtil.md5((String)jsonStr, (Long)timestamp, (String)"123456"));
                if (!(StringUtil.isNotEmpty((String)md5) && StringUtil.isNotEmpty((String)jsonStr) && checkMd5.equals(md5))) {
                    throw new Exception("md5\u6821\u9a8c\u5931\u8d25\uff0c\u767b\u5f55\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u51fa\u9519:" + sessionId);
                }
            } else {
                throw new Exception("session\u4fe1\u606f\u8fc7\u671f\uff0c\u65e0\u6cd5\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u6821\u9a8c\u51fa\u9519:" + sessionId);
            }
            authInfo.setCheckToken(true);
            authInfo.setUserInfo(userInfo);
        }
        catch (Exception e) {
            logger.error("sso client request token check fail: " + e.getMessage(), (Throwable)e);
            if (this.failRedirect) {
                response.sendRedirect(this.constructRedirectUrl(request));
                return;
            }
            response.setStatus(401);
            ResponseData data = new ResponseData();
            data.createData((Object)false, "-1", "valify token \u9519\u8bef", false);
            String outputmessage = GsonUtils.toJson((Object)data);
            try (PrintWriter rsp = response.getWriter();){
                rsp.write(outputmessage);
            }
            return;
        }
        if (authInfo == null || !authInfo.isCheckToken() || authInfo.getUserInfo() == null || authInfo.getUserInfo().getUserId() == null) {
            logger.info("\u767b\u5f55\u6821\u9a8c\u5931\u8d25\uff1a" + authInfo);
            if (this.failRedirect) {
                response.sendRedirect(this.constructRedirectUrl(request));
                return;
            }
            response.setStatus(401);
            ResponseData data = new ResponseData();
            data.createData((Object)false, "-1", "\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25", false);
            String outputmessage = GsonUtils.toJson((Object)data);
            try (PrintWriter rsp = response.getWriter();){
                rsp.write(outputmessage);
            }
            return;
        }
        logger.info("\u6821\u9a8c\u901a\u8fc7");
        request.getSession().setAttribute("userInfo", (Object)authInfo.getUserInfo());
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    public static Map<String, String> parseQuerystring(String queryString) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString == null || queryString.equals("")) {
            return map;
        }
        for (String param : params = queryString.split("&")) {
            try {
                String[] keyValuePair = param.split("=", 2);
                String name = URLDecoder.decode(keyValuePair[0], "UTF-8");
                if (name == "") continue;
                String value = keyValuePair.length > 1 ? URLDecoder.decode(keyValuePair[1].replaceAll("%20", "%2b"), "UTF-8") : "";
                map.put(name, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return map;
    }

    private String constructRedirectUrl(HttpServletRequest request) {
        try {
            String requestPath = request.getServletPath();
            if (StringUtils.indexOf((CharSequence)requestPath, (CharSequence)"login.html") > 0) {
                return "/login.html";
            }
            String queryString = request.getQueryString();
            queryString = StringUtils.isNotBlank((CharSequence)queryString) ? "?" + queryString : "";
            String url = "/login.html?service=" + URLEncoder.encode(String.format("%s%s", requestPath, queryString), "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
            return url;
        }
        catch (Exception e) {
            logger.error("\u6784\u5efa\u91cd\u5b9a\u5411\u8def\u5f84\u5931\u8d25 {}", (Object)e.getMessage(), (Object)e);
            return "/login.html";
        }
    }

    public static void main(String[] args) {
        String requestPath = "/static/css/te/test.jpg";
        String passedPath = "/static/**/*.jpg";
        AntPathMatcher matcher = new AntPathMatcher();
        System.out.println(matcher.match(passedPath, requestPath));
    }
}

