/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.card.application.operation;

import com.irdstudio.allintpaas.sdk.card.acl.repository.CardPageLayoutRepository;
import com.irdstudio.allintpaas.sdk.card.domain.entity.CardPageLayoutDO;
import com.irdstudio.allintpaas.sdk.card.facade.operation.CardPageLayoutService;
import com.irdstudio.allintpaas.sdk.card.facade.operation.dto.CardPageLayoutDTO;
import com.irdstudio.framework.beans.core.base.BaseServiceImpl;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.vo.BaseInfo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="CardPageLayoutServiceImpl")
public class CardPageLayoutServiceImpl
extends BaseServiceImpl<CardPageLayoutDTO, CardPageLayoutDO, CardPageLayoutRepository>
implements CardPageLayoutService {
    final String defaultLayoutId = "default";

    public int insertSingle(CardPageLayoutDTO input) {
        int output = super.insertSingle((Object)input);
        return output;
    }

    public int updateByPk(CardPageLayoutDTO input) {
        int output = super.updateByPk((BaseInfo)input);
        return output;
    }

    public CardPageLayoutDTO queryByPk(CardPageLayoutDTO input) {
        CardPageLayoutDTO output = (CardPageLayoutDTO)super.queryByPk((BaseInfo)input);
        if (output == null) {
            CardPageLayoutDO cardPageLayout = new CardPageLayoutDO();
            cardPageLayout.setLayoutId("default");
            cardPageLayout.setPageId(input.getPageId());
            cardPageLayout.setCardId(input.getCardId());
            cardPageLayout = (CardPageLayoutDO)((CardPageLayoutRepository)this.getRepository()).queryByPk((Object)cardPageLayout);
            if (cardPageLayout != null) {
                cardPageLayout.setLayoutId(input.getLayoutId());
                ((CardPageLayoutRepository)this.getRepository()).insert((Object)cardPageLayout);
                output = (CardPageLayoutDTO)this.beanCopy(cardPageLayout, CardPageLayoutDTO.class);
            }
        }
        return output;
    }

    public int deleteByPk(CardPageLayoutDTO input) {
        int output = super.deleteByPk((BaseInfo)input);
        return output;
    }

    public List<CardPageLayoutDTO> queryList(CardPageLayoutDTO input) {
        List sPortalPageLayouts = super.queryList((BaseInfo)input);
        if (CollectionUtils.isEmpty((Collection)sPortalPageLayouts) && !StringUtils.equals((CharSequence)input.getLayoutId(), (CharSequence)"default") && StringUtils.isNotBlank((CharSequence)input.getPageId())) {
            CardPageLayoutDTO defaultLayoutParam = new CardPageLayoutDTO();
            defaultLayoutParam.setLayoutId("default");
            defaultLayoutParam.setPageId(input.getPageId());
            sPortalPageLayouts = super.queryList((BaseInfo)defaultLayoutParam);
            String now = CurrentDateUtil.getTodayDateEx2();
            String layoutId = input.getLayoutId();
            CardPageLayoutService service = (CardPageLayoutService)SpringContextUtils.getBean(CardPageLayoutService.class);
            for (CardPageLayoutDTO card : sPortalPageLayouts) {
                card.setLayoutId(layoutId);
                card.setCreateTime(now);
                card.setCreateUser(input.getLoginUserId());
                service.insert((Object)card);
            }
        }
        List list = null;
        try {
            this.pageSet(sPortalPageLayouts, (BaseInfo)input);
            list = sPortalPageLayouts;
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    public int deleteByCond(CardPageLayoutDTO param) {
        CardPageLayoutDO cardPageLayoutDO = new CardPageLayoutDO();
        this.beanCopy(param, cardPageLayoutDO);
        return ((CardPageLayoutRepository)this.getRepository()).deleteByCond(cardPageLayoutDO);
    }

    public int updateList(List<CardPageLayoutDTO> list) {
        int output = 0;
        if (CollectionUtils.isNotEmpty(list)) {
            List doList = this.beansCopy(list, CardPageLayoutDO.class);
            for (CardPageLayoutDO layout : doList) {
                output += ((CardPageLayoutRepository)this.getRepository()).updateByPk((Object)layout);
            }
        }
        return output;
    }
}

