(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 我的查询配置面板
    exports.MyQueryPanel = {
        props: {
            qryId : String,
            userId : String,
            cond: {
                type: Array
            },
            result: {
                type: Array
            },
            sort: {
                type: Array
            },
        },
        inject: ['queryCondConfig', 'querySortConfig', 'queryResultConfig'],
        emits: ['update:result', 'update:sort'],
        data(){
            return {
                loading: false,
                filterCond: [],
            }
        },
        watch: {
            cond: {
                handler: function(val) {
                    setTimeout(()=>{
                        this.filterCond = val;
                    }, 50)
                }
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            getJsonData() {
                let jsonData = {
                    qryId: this.qryId,
                    ownerUserid: this.userId,
                    qryCond : this.filterCond.map(el=>{
                        return {
                            _id: el._id,
                            type: el.type,
                            logicOp: el.logicOp,
                            op: el.op,
                            colNames: el.colNames,
                            key: el.key,
                            keys: el.keys,
                            values: el.values,
                            valueNames: el.valueNames,
                            name: el.name,
                            thisDate: el.thisDate
                        }
                    }),
                    qryResult : this.result,
                    qrySort : this.sort,
                }
                return jsonData
            },
            search() {
                this.$emit('search', vue.toRaw(this.getJsonData()));
            },
            saveToQrySecond() {
                const jsonData = this.getJsonData();
                window.top.$$qrySecondData = jsonData;
                ElementDialog.createDialog('保存为我的查询', contextPath+ 'page/allintpaas/sdk/query/manual/QrySecondUpdate.html?qryId=' + jsonData.qryId)
                    .then(data=>{
                        this.$emit('save', vue.toRaw(jsonData))
                    })
            },
            closePanel() {
                this.$emit('close')
            },
            saveListOrder(e) {

            },
            selectResult(item, index) {
                this.resultValue.push(item)
                this.$emit('update:result',  this.resultValue.map(el=>el._id))
            },
            removeResult(item, index) {
                this.resultValue.splice(index, 1)
                this.$emit('update:result',  this.resultValue.map(el=>el._id))
            },
            saveResultListOrder() {
                const self = this;
                const newList = []
                $('.draggable.qry-result').each(function(index, el) {
                    const id = $(el).attr('my-tag-id')
                    newList.push(id)
                })
                this.$emit('update:result',  newList)
            },
            selectSort(item, index) {
                this.sortValue.push(item)
                this.$emit('update:sort',  this.sortValue.map(el=>el._id))
            },
            removeSort(item, index) {
                this.sortValue.splice(index, 1)
                this.$emit('update:sort',  this.sortValue.map(el=>el._id))
            },
            saveSortListOrder() {
                const self = this;
                const newList = []
                $('.draggable.qry-sort').each(function(index, el) {
                    const id = $(el).attr('my-tag-id')
                    newList.push(id)
                })
                this.$emit('update:sort',  newList)
            }
        },
        computed:{
            height() {
                return 200;
            },
            resultValue: {
                get() {
                    const { result, queryResultConfig } = this
                    return result.map(el=>queryResultConfig.find(q=>q._id === el))
                },
                set(val) {
                    this.$emit('update:result',  val.map(el=>el._id))
                }
            },
            unSelectResult() {
                const { result } = this
                return this.queryResultConfig.filter(el=>result.indexOf(el._id) < 0)
            },
            sortValue: {
                get() {
                    const { sort, querySortConfig } = this
                    return sort.map(el=>querySortConfig.find(q=>q._id === el))
                },
                set(val) {
                    this.$emit('update:sort', val.map(el=>el._id))
                }
            },
            unSelectSort() {
                const { sort } = this
                return this.querySortConfig.filter(el=>sort.indexOf(el._id) < 0)
            },

            options() {
                return {
                    handle: ".draggable",
                    draggable: ".draggable",
                    animation: 150,
                    ghostClass: "ghost",
                    dragClass: "drag",
                    scroll: true,
                    forceFallback: true,
                    scrollSensitivity: 50,
                    scrollSpeed: 10,
                    bubbleScroll: true,
                }
            },
            DIC() {
                return {
                    SORT_TYPE : [
                        {"enname": "asc", "cnname": "升序"},
                        {"enname": "desc", "cnname": "降序"}
                    ]
                }
            }
        },
        mounted() {
            const self = this;
            setTimeout(()=>{
                this.filterCond = this.cond;
            }, 50)
        },
        unmounted() {

        },
        template: `
<div>
    <el-tabs class="my-query-panel-card" type="border-card">
        <el-tab-pane label="查询条件">
            <filter-condition v-model="filterCond" :visible="true" :config="queryCondConfig" hide-btn ></filter-condition>
        </el-tab-pane>
        <el-tab-pane label="查询结果">
            <el-row :gutter="20">
                <el-col :span="12">
                    <div class="qry-header">可选结果字段</div>
                    <el-scrollbar :height="height" wrap-class="qry-main">
                        <el-tag v-for="(element, index) in unSelectResult"  class="qry-item" :key="index" type="primary" @click="selectResult(element, index)"> {{ element.label  }} </el-tag>
                    </el-scrollbar>
                </el-col>
                <el-col :span="12">
                    <div class="qry-header">已选结果字段</div>
                    <el-scrollbar :height="height" wrap-class="qry-main">
                    <Sortable 
                              :list="resultValue"
                              tag="div"
                              item-key="_id"
                              :options="options"
                              class="qry-item-container"
                              @end="saveResultListOrder"
                    >
                        <template #item="{ element, index }">
                            <el-tag class="draggable qry-item qry-result" :key="index" :my-tag-id="element._id" closable type="primary" @close="removeResult(element, index)"> {{ element.label  }} </el-tag>
                        </template>
                    </Sortable>
                    </el-scrollbar>
                </el-col>
            </el-row>
        </el-tab-pane>
        <el-tab-pane label="排序字段">
            <el-row :gutter="20">
                <el-col :span="12">
                    <div class="qry-header">可选排序字段</div>
                    <el-scrollbar :height="height" wrap-class="qry-main">
                        <el-tag v-for="(element, index) in unSelectSort"  class="qry-item" :key="index" type="primary" @click="selectSort(element, index)"> {{ element.sortName  }}({{formatterDic('SORT_TYPE', element.type)}}) </el-tag>
                    </el-scrollbar>
                </el-col>
                <el-col :span="12">
                    <div class="qry-header">已选排序字段</div>
                    <el-scrollbar :height="height" wrap-class="qry-main">
                    <Sortable 
                              :list="sortValue"
                              tag="div"
                              item-key="_id"
                              :options="options"
                              class="qry-item-container"
                              @end="saveSortListOrder"
                    >
                        <template #item="{ element, index }">
                            <el-tag class="draggable qry-item qry-sort" :key="index" :my-tag-id="element._id" closable type="primary" @close="removeSort(element, index)"> {{ element.sortName  }}({{formatterDic('SORT_TYPE', element.type)}}) </el-tag>
                        </template>
                    </Sortable>
                    </el-scrollbar>
                </el-col>
            </el-row>
        </el-tab-pane>
    </el-tabs>
    <div style="display: flex; justify-content: center;margin: 15px;">
        <el-button type="primary" round icon="Search" @click="search" size="small">查询</el-button>
        <el-button type="primary" round icon="Check" @click="saveToQrySecond" size="small">保存为我的查询</el-button>
        <el-button type="default" round icon="TopRight" @click="closePanel" size="small">收起</el-button>
    </div>
</div>
        `
    }

}));