(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 指标加工
    exports.IndModelTransformList = {
        props: {
            indId: String
        },
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                dgUrl: window.contextPath + 'api/IndModelTransform/queryList',
                signUserId: signUserId,
                queryParams: {
                    "indId": this.indId,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],
                loading: false,
                currentRow: undefined,

                viewModel: "list", // 视图
                // 过滤条件
                showFilter: false,
                filterCond: [],
                groupItem: undefined,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    if (this.DIC[dicName]) {
                        return JLEUtil.formatter_dict(value, this.DIC[dicName])
                    }
                    console.error(dicName, e)
                }
            },
            handlerTableCurrentChange(row) {
                this.currentRow = row;
            },
            resetQueryParams() {
                // 查询条件重置
                const self = this;
                self.all = '';
                self.allName = 'all';
                self.queryList();
            },
            queryParamsHandler(params){
                const self = this;
                params[self.allName] = self.all ;
                // 过滤条件
                if (this.filterCond && this.filterCond.length > 0) {
                    params.filterCond = JSON.stringify(this.filterCond)
                }
                return params
            },
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                self.queryParamsHandler(params);
                $.restfulPostJson(self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                }, function(){ self.loading = false; }, true);
            },
            doAdd(row){
                const self = this
                ElementDialog.createDialog(`新增`,`${contextPath}page/allintpaas/sdk/index/IndModelTransformAdd.html?indId=` + this.indId)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doUpdate(row){
                const self = this
                ElementDialog.createDialog(`修改`,`${contextPath}page/allintpaas/sdk/index/IndModelTransformUpdate.html?indTransformId=${row.indTransformId}&indId=${row.indId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            doDelete(row){
                const self = this
                ElementPlus.ElMessageBox.confirm(
                    '你确定要删除这条记录?',
                    '提示',
                    {
                        confirmButtonText: '确定',
                        cancelButtonText: '取消',
                        type: 'warning',
                    }
                ).then(() => {
                    $.restfulPostJson(contextPath + 'api/IndModelTransform/deleteByPk', {
                        'indTransformId' : row.indTransformId,
                    }, function(data){
                        if (data.success) {
                            ElementPlus.ElMessage({
                                showClose: true,
                                message: data.message,
                                type: 'success',
                            })
                            self.queryList();
                        } else {
                            ElementPlus.ElMessage({
                                showClose: true,
                                message: data.message,
                                type: 'error',
                            })
                        }
                    }, undefined, true);
                })
            },
            doView(row){
                const self = this
                ElementDialog.createDialog(`查看`,`${contextPath}page/allintpaas/sdk/index/IndModelTransformView.html?indTransformId=${row.indTransformId}`)
                    .then(()=>{
                        self.queryList()
                    });
            },
            handlerCommand(param) {
                const self = this;
                if (self[param.command]) {
                    self[param.command](param.row);
                }
            },
            allSearch(params) {
                this.allName = params && params.allName;
                this.all = params && params.all;
                this.queryList();
            },
            changeView(item) {
                this.viewModel = item.value
                if (this.queryList) {
                    this.queryList()
                }
            },
            changeSort(item, initFlag) {
                const queryParams = this.queryParams || {}
                queryParams.ascOrder = "";
                queryParams.descOrder = "";
                if (item.type == 'desc') {
                    queryParams.descOrder = item.key
                } else {
                    queryParams.ascOrder = item.key
                }
                if (this.queryList  && !initFlag) {
                    this.queryList()
                }
            },
            handlerDblclick(row) {
                this.handlerTableCurrentChange(row);
                this.submitForm()
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            submitForm() {
                if (this.currentRow) {
                    this.$emit('next', Vue.unref(this.currentRow))
                } else {
                    ElementPlus.ElMessage({
                        showClose: true,
                        message: '请选择一条记录！',
                        type: 'warning',
                    })
                }
            }
        },
        computed:{
            breadcrumb() {
                return `指标加工列表`
            },

            DIC() {
                return {
                }
            },
            filterConfig() {
                return [
                    { key: 'indTransformId', name: '指标加工标识', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                    { key: 'indTransformSql', name: '指标加工Sql', type: 'input', opType: '', opOption: window.FILTER_OP_TYPE.filter(el=>['lk'].indexOf(el.enname) >= 0), },
                ]
            },
            sortConfig() {
                return [
                    {label: '按排序字段顺序', key: 'orderValue', type: 'asc'},
                    {label: '按排序字段倒序', key: 'orderValue', type: 'desc'},
                ]
            },
            groupConfig() {
                return [

                ]
            },
            listView() {
                return this.viewModel == 'list'
            },
            dashboardView() {
                return this.viewModel == 'dashboard'
            },
        },
        mounted() {
            const self = this;
            self.groupItem = self.groupConfig[0];
            self.queryList();
        },
        unmounted() {

        },
        template: `
<el-row>
<el-col :span="24">
    <el-card class="box-card pure-theme" shadow="never">
        <template #header>
            <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                <template #right>
                    <filter-button v-model="showFilter" :count="filterCond.length"></filter-button>
                    <group-dropdown v-model="groupItem"  v-if="false" :group-config="groupConfig"></group-dropdown>
                    <sort-dropdown @sort="changeSort" :sort-item="sortConfig"></sort-dropdown>
                    <el-button class="button" icon="Refresh" text size="small" @click="queryList"></el-button>
                </template>
            </page-header>
        </template>
        <el-row>
            <el-col :span="24">
                <page-search ref="searchRef"
                             enable-search
                             :all-items="[]"
                             @all-search="allSearch"
                >
                    <template #more>
                        <el-form class="card-form" ref="formRef" :show-message="false" label-width="133px" label-position="left">
                            <filter-condition v-model="filterCond" :visible="showFilter" :config="filterConfig" @close="showFilter = false" @filter="queryList" ></filter-condition>
                            <el-row v-if="groupItem">
                                <el-col :span="24">
                                    <group-item :item="groupItem" @cancel="groupItem = undefined"></group-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </template>
                </page-search>
                <template v-if="listView">
                    <el-table :data="tableData"
                              v-loading="loading"
                              stripe
                              highlight-current-row
                              @current-change="handlerTableCurrentChange" @row-dblclick="handlerDblclick"
                              tooltip-effect="light"
                              :tooltip-options="{placement : 'bottom'}"
                              style="width: 100%" >
                        <el-table-column type="index" width="45" ></el-table-column>
                        <el-table-column prop="indTransformId" label="指标加工标识"  show-overflow-tooltip   >
                            <template #default="{row, $index}">
                                <el-link type="primary" :underline="false" @click="indTransformIdColHandler(row)">{{row.indTransformId}}</el-link>
                            </template>
                        </el-table-column>
                        <el-table-column prop="indTransformSql" label="指标加工sql"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column prop="orderValue" label="排序字段"  show-overflow-tooltip   >
                        </el-table-column>
                        <el-table-column label="操作" width="180" header-align="center">
                            <template #default="{row, $index}">
                            <el-button class="button" text type="default"  icon="Edit"  @click="doUpdate(row)">修改</el-button>
                            <el-button class="button" text type="default"  icon="Delete"  @click="doDelete(row)">删除</el-button>
                            </template>
                        </el-table-column>
                    </el-table>
                    <page-table-pagination :page-info="pageInfo" :load-method="queryList"></page-table-pagination>
                </template>
            </el-col>
        </el-row>
    </el-card>
</el-col>
</el-row>
        `
    }

}));