(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _, loadjs) {


    // 指标订阅
    exports.IndSubscribeInfoStep = {
        props: ['params', 'step', 'total'],
        inject: ['searchParams', 'windowHeight'],
        data(){
            return {
                formData: {
                    "subscribeId": "",
                    "subscribeDesc": "",
                    "subscribeUserId": "",
                    "subscribeUserName": "",
                    "subscribeParams": "",
                    "indId": "",
                    "indCode": "",
                    "indName": "",
                    "indCategory": "",
                    "indType": "",
                    "pushMineInd": "",
                    "pushFollowInd": "",
                    "pushEmailFlag": "",
                    "pushSmsFlag": "",
                },

                loading: false,
                disabled: true,
            }
        },
        methods: {
            formatterDic(dicName, value, row, index) {
                try {
                    return window[`formatter_${dicName}`](value, row, index);
                } catch(e) {
                    console.error(dicName, e)
                }
            },
            queryData() {
                const self = this;
                _.assignWith(self.formData, self.params.indModelInfo, (objValue, srcValue)=>{ return _.isUndefined(srcValue) ? objValue : srcValue });
                self.formData.subscribeUserId = self.params.subscribeUserId;
                self.formData.subscribeUserName = self.params.subscribeUserName;
            },
            closeForm() {
                this.$emit('close')
            },
            backStep(){
                this.$emit('back')
            },
            handleCatalogChange() {
                this.formData.taskType = ''
            },
            submitForm() {
                const self = this;
                self.loading = true;
                self.loading = true;
                self.$refs.formRef.validate((valid, fields) => {
                    if (valid) {
                        const jsonData = Vue.toRaw(self.formData);
                        $.restfulPostJson(contextPath + 'api/IndSubscribeInfo/insertSingle', {
                            ...jsonData,
                        }, function(data) {
                            self.$emit('next', vue.toRaw(self.formData));
                            self.loading = false;
                        }, function(e){
                            self.loading = false;
                            ElementPlus.ElMessage({showClose: true, message: '保存失败', type: 'error',})
                        }, true);
                    } else {
                        self.loading = false;
                    }
                })

            },
        },
        computed:{
            breadcrumb() {
                return `指标订阅信息`
            },

            rules(){
                return {
                    "subscribeId": [
                        { required: false, message: '订阅标识不能为空' },
                    ],
                    "subscribeDesc": [
                        { required: true, message: '订阅描述不能为空' },
                    ],
                    "subscribeUserId": [
                        { required: true, message: '订阅用户不能为空' },
                    ],
                    "subscribeUserName": [
                        { required: true, message: '订阅用户名称不能为空' },
                    ],
                    "indId": [
                        { required: true, message: '指标标识不能为空' },
                    ],
                    "pushMineInd": [
                        { required: true, message: '展示到我的指标不能为空' },
                    ],
                    "pushFollowInd": [
                        { required: true, message: '展示到我关注的指标不能为空' },
                    ],
                    "pushEmailFlag": [
                        { required: true, message: '邮件发送内容不能为空' },
                    ],
                    "pushSmsFlag": [
                        { required: true, message: '短信通知不能为空' },
                    ],
                }
            },
            DIC() {
                return {

                    IND_CATEGORY: [
                        { 'enname': 'F', 'cnname': '固定指标' },
                        { 'enname': 'S', 'cnname': '订阅指标' },
                    ],
                    IND_TYPE: [
                        { 'enname': 'D', 'cnname': '日指标' },
                        { 'enname': 'M', 'cnname': '月指标' },
                        { 'enname': 'S', 'cnname': '季指标' },
                        { 'enname': 'W', 'cnname': '周指标' },
                        { 'enname': 'Y', 'cnname': '年指标' },
                    ],
                    STD_PUB_YN: [
                        { 'enname': 'N', 'cnname': '否' },
                        { 'enname': 'Y', 'cnname': '是' },
                    ],
                }
            },

            checkList: {
                get() {
                    let arr = []
                    if (this.formData.pushMineInd == 'Y') {
                        arr.push('pushMineInd')
                    }
                    if (this.formData.pushFollowInd == 'Y') {
                        arr.push('pushFollowInd')
                    }
                    if (this.formData.pushEmailFlag == 'Y') {
                        arr.push('pushEmailFlag')
                    }
                    if (this.formData.pushSmsFlag == 'Y') {
                        arr.push('pushSmsFlag')
                    }
                    return arr
                },
                set(val) {
                    const self = this;
                    this.formData.pushMineInd = 'N'
                    this.formData.pushFollowInd = 'N'
                    this.formData.pushEmailFlag = 'N'
                    this.formData.pushSmsFlag = 'N'
                    if (val) {
                        val.forEach(function(el) {
                            self.formData[el] = 'Y'
                        })
                    }
                }
            }
        },
        mounted() {
            const self = this;
            self.queryData();
        },
        unmounted() {

        },
        template: `
        <el-col :span="24">
            <el-card class="box-card pure-theme" shadow="never">
                <template #header>
                    <page-header class="inner-title" :breadcrumb="breadcrumb" card-header>
                    </page-header>
                </template>
                <el-row>
                    <el-col :span="24">
                        <el-form class="card-form" v-loading="loading" ref="formRef" :show-message="true"
                             :model="formData"
                             :rules="rules"
                             label-width="120px">
                            <el-row :gutter="1">
                                <el-col :span="24"  >
                                    <el-form-item label="指标订阅描述" prop="subscribeDesc">
                                        <el-input v-model="formData.subscribeDesc" :disabled="false" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="指标编号" prop="indId">
                                        <el-input v-model="formData.indId" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="指标代码" prop="indCode">
                                        <el-input v-model="formData.indCode" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="指标名称" prop="indName">
                                        <el-input v-model="formData.indName" :disabled="disabled" ></el-input>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="指标类别" prop="indCategory">
                                        <combobox v-model="formData.indCategory" placeholder="请选择指标类别" clearable :disabled="disabled" :op-type="DIC.IND_CATEGORY" > </combobox>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="12"  >
                                    <el-form-item label="指标类型" prop="indType">
                                        <combobox v-model="formData.indType" placeholder="请选择指标类型" clearable :disabled="disabled" :op-type="DIC.IND_TYPE" > </combobox>
                                    </el-form-item>
                                </el-col>
                                <el-col :span="24">
                                    <el-form-item label="订阅方式" prop="checkList">
                                        <el-checkbox-group v-model="checkList" :disabled="false">
                                            <el-checkbox label="pushMineInd" disabled>展示到我的指标</el-checkbox>
                                            <el-checkbox label="pushFollowInd" >展示到我关注的指标</el-checkbox>
                                            <el-checkbox label="pushEmailFlag" >邮件发送内容</el-checkbox>
                                            <el-checkbox label="pushSmsFlag" >短信通知</el-checkbox>
                                        </el-checkbox-group>
                                    </el-form-item>
                                </el-col>
                            </el-row>
                        </el-form>
                    </el-col>
                </el-row>
            </el-card>
            <div class="esaas-info-buttons" :style="{ bottom: 'inherit', top: windowHeight.value - 40 } ">
                <div>
                    <el-button type="primary" icon="Back" @click="backStep" v-if="step > 1 && step < total" v-loading="loading" size="small">&nbsp;上一步&nbsp;</el-button>
                    <el-button type="primary" icon="Right" @click="submitForm" v-loading="loading" size="small">&nbsp;下一步&nbsp;</el-button>
                    <el-button type="default" icon="Close" @click="closeForm" size="small">&nbsp;关&nbsp;闭&nbsp;</el-button>
                </div>
            </div>
        </el-col>
        `
    }

}));