/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.report.manual.web.operation;

import com.irdstudio.allintpaas.sdk.report.facade.operation.RptInstInfoService;
import com.irdstudio.allintpaas.sdk.report.facade.operation.dto.RptInstInfoDTO;
import com.irdstudio.allintpaas.sdk.report.manual.facade.operation.RptExportManualService;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.web.controller.AbstractController;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
public class RptInstInfoManualController
extends AbstractController {
    @Autowired
    private RptInstInfoService rptInstInfoService;
    @Autowired
    private RptExportManualService rptExportManualService;

    @RequestMapping(value={"/api/RptInstInfo/exportToPdf"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> exportToPdf(@RequestParam(value="rptInstId") String rptInstId, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate, @RequestParam(value="rptModelId") String rptModelId, HttpServletRequest request, HttpServletResponse response) {
        RptInstInfoDTO instInfo = new RptInstInfoDTO();
        instInfo.setRptInstId(rptInstId);
        instInfo = this.rptInstInfoService.queryByPk(instInfo);
        File pdfFile = this.rptExportManualService.exportToPdf(rptInstId, rptModelId, startDate, endDate);
        if (pdfFile == null) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", instInfo.getRptInstName(), rptInstId));
        }
        File file = pdfFile;
        if (!file.exists()) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e22\u5931", instInfo.getRptInstName(), rptInstId));
        }
        if (StringUtils.isBlank((CharSequence)startDate)) {
            startDate = CurrentDateUtil.getTodayDate();
        }
        String fileName = String.format("%s(%s)-%s.pdf", instInfo.getRptInstName(), rptInstId, startDate);
        try {
            Path filePath = Paths.get(file.getAbsolutePath(), new String[0]);
            UrlResource resource = new UrlResource(filePath.toUri());
            String contentType = "application/pdf";
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + new String(fileName.getBytes(), "iso-8859-1") + "\""})).body((Object)resource);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("%s[%s]\u5bf9\u5e94\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38%s", instInfo.getRptInstName(), rptInstId, e.getMessage()));
        }
    }
}

