/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allintpaas.sdk.sequence.infra.repository.impl;

import com.irdstudio.allintpaas.sdk.sequence.acl.repository.SeqInstInfoRepository;
import com.irdstudio.allintpaas.sdk.sequence.acl.repository.SeqModelInfoRepository;
import com.irdstudio.allintpaas.sdk.sequence.domain.entity.SeqInstInfoDO;
import com.irdstudio.allintpaas.sdk.sequence.domain.entity.SeqModelInfoDO;
import com.irdstudio.allintpaas.sdk.sequence.infra.persistence.mapper.SeqInstInfoMapper;
import com.irdstudio.allintpaas.sdk.sequence.infra.persistence.po.SeqInstInfoPO;
import com.irdstudio.allintpaas.sdk.sequence.types.SeqCycleFlag;
import com.irdstudio.allintpaas.sdk.sequence.types.YesOrNO;
import com.irdstudio.framework.beans.core.base.BaseRepositoryImpl;
import com.irdstudio.framework.beans.core.spring.ExpressionUtil;
import com.irdstudio.framework.beans.core.util.CurrentDateUtil;
import com.irdstudio.framework.beans.core.util.SpringContextUtils;
import com.irdstudio.framework.beans.core.util.UUIDUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="seqInstInfoRepositoryImpl")
public class SeqInstInfoRepositoryImpl
extends BaseRepositoryImpl<SeqInstInfoDO, SeqInstInfoPO, SeqInstInfoMapper>
implements SeqInstInfoRepository {
    private static final Map<String, SeqInstInfoPO> seqInstMap = new ConcurrentHashMap<String, SeqInstInfoPO>();

    public String nextAndSave(String seqId, String seqName, String seqType, String startValue, String maxValue, String incrementValue, String cycleFlag, String cacheValue, String seqTemplate, String seqPlace, String zeroFill, String ... owner) {
        String key = this.getSeqKey(seqId, owner);
        SeqInstInfoPO inst = seqInstMap.get(key);
        if (inst == null) {
            SeqModelInfoRepository configService = (SeqModelInfoRepository)SpringContextUtils.getBean(SeqModelInfoRepository.class);
            SeqModelInfoDO seqConfig = new SeqModelInfoDO();
            seqConfig.setSeqId(seqId);
            seqConfig = (SeqModelInfoDO)configService.queryByPk((Object)seqConfig);
            if (seqConfig == null) {
                seqConfig = new SeqModelInfoDO();
                seqConfig.setSeqId(seqId);
                seqConfig.setSeqName(seqName);
                seqConfig.setSeqType(seqType);
                seqConfig.setStartValue(Integer.valueOf(NumberUtils.toInt((String)startValue, (int)0)));
                seqConfig.setMaxValue(new BigDecimal(maxValue));
                seqConfig.setIncrementValue(Integer.valueOf(NumberUtils.toInt((String)incrementValue, (int)0)));
                seqConfig.setCycleFlag(cycleFlag);
                seqConfig.setCacheValue(Integer.valueOf(NumberUtils.toInt((String)cacheValue, (int)0)));
                seqConfig.setSeqTemplate(seqTemplate);
                seqConfig.setSeqPlace(Integer.valueOf(NumberUtils.toInt((String)seqPlace, (int)0)));
                seqConfig.setZeroFill(zeroFill);
                seqConfig.setCreateUser("system");
                seqConfig.setCreateTime(CurrentDateUtil.getTodayDateEx2());
                seqConfig.setLastModifyUser("system");
                seqConfig.setLastModifyTime(seqConfig.getCreateTime());
                configService.insert((Object)seqConfig);
            }
        }
        return this.nextSequence(seqId, owner);
    }

    public String nextSequence(String seqId, String ... owner) {
        String key;
        SeqInstInfoPO inst;
        if (owner == null) {
            owner = new String[]{};
        }
        if ((inst = seqInstMap.get(key = this.getSeqKey(seqId, owner))) == null) {
            SeqModelInfoRepository configService = (SeqModelInfoRepository)SpringContextUtils.getBean(SeqModelInfoRepository.class);
            SeqModelInfoDO seqConfig = new SeqModelInfoDO();
            seqConfig.setSeqId(seqId);
            seqConfig = (SeqModelInfoDO)configService.queryByPk((Object)seqConfig);
            if (seqConfig == null) {
                throw new RuntimeException(String.format("\u65e0\u6cd5\u83b7\u53d6\u3010%s\u3011\u5e8f\u5217\u914d\u7f6e", seqId));
            }
            inst = new SeqInstInfoPO();
            this.beanCopy(seqConfig, (Object)inst);
            inst.setCreateTime(CurrentDateUtil.getTodayDateEx2());
            inst.setCreateUser("system");
            inst.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            inst.setLastModifyUser("system");
            inst.setLastDbCurrentValue(inst.getCurrentValue());
            if (owner.length > 0) {
                inst.setOwner1(owner[0]);
            }
            if (owner.length > 1) {
                inst.setOwner2(owner[1]);
            }
            if (owner.length > 2) {
                inst.setOwner3(owner[2]);
            }
            seqInstMap.put(key, inst);
            inst.setId(UUIDUtil.getShortUUID());
            ((SeqInstInfoMapper)this.getMapper()).insert((Object)inst);
        }
        return this.genSequence(inst);
    }

    private synchronized String genSequence(SeqInstInfoPO inst) {
        Integer cacheValue;
        Integer incrementValue;
        HashMap<String, String> variables = new HashMap<String, String>();
        Calendar calender = Calendar.getInstance();
        variables.put("yyyy", DateFormatUtils.format((Calendar)calender, (String)"yyyy"));
        variables.put("MM", DateFormatUtils.format((Calendar)calender, (String)"MM"));
        variables.put("dd", DateFormatUtils.format((Calendar)calender, (String)"dd"));
        variables.put("HH", DateFormatUtils.format((Calendar)calender, (String)"HH"));
        variables.put("mm", DateFormatUtils.format((Calendar)calender, (String)"mm"));
        variables.put("ss", DateFormatUtils.format((Calendar)calender, (String)"ss"));
        variables.put("yyyyMMddHHmmss", DateFormatUtils.format((Calendar)calender, (String)"yyyyMMddHHmmss"));
        variables.put("yyyyMMddHHmmssSSS", DateFormatUtils.format((Calendar)calender, (String)"yyyyMMddHHmmssSSS"));
        variables.put("owner1", StringUtils.isBlank((CharSequence)inst.getOwner1()) ? "" : inst.getOwner1());
        variables.put("owner2", StringUtils.isBlank((CharSequence)inst.getOwner2()) ? "" : inst.getOwner2());
        variables.put("owner3", StringUtils.isBlank((CharSequence)inst.getOwner3()) ? "" : inst.getOwner3());
        variables.put("UUID", UUIDUtil.getUUID());
        variables.put("SUUID", UUIDUtil.getShortUUID());
        Integer seq = inst.getCurrentValue();
        if (seq == null) {
            seq = inst.getStartValue();
            if (seq == null) {
                seq = 0;
                inst.setStartValue(seq);
            }
            inst.setCurrentValue(seq);
        }
        if ((incrementValue = inst.getIncrementValue()) == null) {
            incrementValue = 1;
            inst.setIncrementValue(incrementValue);
        }
        seq = seq + incrementValue;
        String strSeq = String.valueOf(seq);
        if (StringUtils.equalsIgnoreCase((CharSequence)inst.getZeroFill(), (CharSequence)YesOrNO.YES.getCode()) && inst.getSeqPlace() != null) {
            Integer seqPlace = inst.getSeqPlace();
            strSeq = StringUtils.leftPad((String)strSeq, (int)seqPlace, (String)"0");
        }
        variables.put("SEQ", strSeq);
        String nextSeq = ExpressionUtil.parseSeq((String)inst.getSeqTemplate(), variables);
        boolean updateFlag = false;
        int overCache = seq - inst.getLastDbCurrentValue();
        if (inst.getCacheValue().compareTo(overCache) <= 0) {
            inst.setLastDbCurrentValue(inst.getCurrentValue());
            updateFlag = true;
        }
        if ((cacheValue = inst.getCacheValue()) == null) {
            inst.setCacheValue(cacheValue);
            cacheValue = 0;
        }
        if (cacheValue.equals(0)) {
            updateFlag = true;
        }
        inst.setCurrentValue(seq);
        if (StringUtils.equals((CharSequence)inst.getCycleFlag(), (CharSequence)SeqCycleFlag.Max.getCode()) && inst.getMaxValue() != null && inst.getMaxValue().compareTo(new BigDecimal(seq)) <= 0) {
            inst.setCurrentValue(inst.getStartValue());
        }
        if (updateFlag) {
            inst.setLastModifyTime(CurrentDateUtil.getTodayDateEx2());
            ((SeqInstInfoMapper)this.getMapper()).updateByPk((Object)inst);
        }
        return nextSeq;
    }

    @PostConstruct
    public void loadSeqInst() {
        try {
            SeqInstInfoPO param = new SeqInstInfoPO();
            List seqList = ((SeqInstInfoMapper)this.getMapper()).queryList((Object)param);
            if (CollectionUtils.isNotEmpty((Collection)seqList)) {
                seqList.forEach(seqInst -> {
                    String key = this.getSeqKey(seqInst.getSeqId(), seqInst.getOwner1(), seqInst.getOwner2(), seqInst.getOwner3());
                    seqInst.setLastDbCurrentValue(seqInst.getCurrentValue());
                    seqInstMap.put(key, (SeqInstInfoPO)((Object)seqInst));
                });
            }
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5e8f\u53f7\u914d\u7f6e\u5f02\u5e38 {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public String reloadSeqInst() {
        seqInstMap.clear();
        this.loadSeqInst();
        return "\u91cd\u8f7d\u6210\u529f";
    }

    private String getSeqKey(String seqId, String ... owner) {
        StringBuffer sb = new StringBuffer(seqId);
        for (String s : owner) {
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            sb.append("-").append(s);
        }
        return sb.toString();
    }

    @Scheduled(cron="01 00 * * * ?")
    public void everyDay() {
        logger.info("\u66f4\u65b0\u5e8f\u5217\uff0c \u68c0\u67e5\u5e8f\u5217\u662f\u5426\u9700\u8981\u5faa\u73af\u5e8f\u5217\u503c");
        if (!seqInstMap.isEmpty()) {
            Calendar calender = Calendar.getInstance();
            block8: for (SeqInstInfoPO inst : seqInstMap.values()) {
                SeqCycleFlag cycleFlag = SeqCycleFlag.getByCode((String)inst.getCycleFlag());
                if (cycleFlag == null || cycleFlag == SeqCycleFlag.None || cycleFlag == SeqCycleFlag.Max) continue;
                switch (cycleFlag) {
                    case Daily: {
                        this.updateInst(inst);
                        continue block8;
                    }
                    case Weekly: {
                        int week = calender.get(7);
                        if (week != 2) continue block8;
                        this.updateInst(inst);
                        continue block8;
                    }
                    case Monthly: {
                        int day = calender.get(5);
                        if (day != 1) continue block8;
                        this.updateInst(inst);
                        continue block8;
                    }
                    case Quarterly: {
                        int mon = calender.get(2);
                        int seasonDay = calender.get(5);
                        if (mon != 0 && mon != 3 && mon != 6 && mon != 10 || seasonDay != 1) continue block8;
                        this.updateInst(inst);
                        continue block8;
                    }
                    case Semiannual: {
                        if (calender.get(2) != 0 && calender.get(2) != 6 || calender.get(5) != 1) continue block8;
                        this.updateInst(inst);
                        continue block8;
                    }
                    case Annually: {
                        if (calender.get(2) != 0 || calender.get(5) != 1) break;
                        this.updateInst(inst);
                    }
                }
            }
        }
    }

    public void updateInst(SeqInstInfoPO inst) {
        inst.setCurrentValue(inst.getStartValue());
        inst.setLastDbCurrentValue(inst.getCurrentValue());
        ((SeqInstInfoMapper)this.getMapper()).updateByPk((Object)inst);
    }
}

