/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.sequence.service.impl;

import com.irdstudio.basic.sequence.service.DefaultPatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternDescriptor;
import com.irdstudio.basic.sequence.service.PatternResolver;
import com.irdstudio.basic.sequence.service.facade.ClassableSeqService;
import com.irdstudio.basic.sequence.service.facade.LimitableSeqService;
import com.irdstudio.basic.sequence.service.facade.PatternedLimitableSeqService;
import com.irdstudio.basic.sequence.service.facade.SeqService;
import com.irdstudio.basic.sequence.service.util.PatternDescriptorHelper;
import java.time.LocalDateTime;
import java.util.Optional;

public class PatternedLimitableSeqServiceImpl
implements PatternedLimitableSeqService {
    private SeqService unClassableSeqGen;
    private ClassableSeqService classableSeqGen;
    private LimitableSeqService limitSeqGen;
    private PatternResolver patternResolver = new InternalPatternResolver();
    private static final String NO_KEY = null;

    public PatternedLimitableSeqServiceImpl(SeqService unClassableSeqGen, LimitableSeqService limitableSeqGen) {
        this(unClassableSeqGen, (ClassableSeqService)limitableSeqGen, limitableSeqGen);
    }

    public PatternedLimitableSeqServiceImpl(SeqService unClassableSeqGen, ClassableSeqService classableSeqGen, LimitableSeqService limitableSeqGen) {
        this(unClassableSeqGen, classableSeqGen, limitableSeqGen, null);
    }

    public PatternedLimitableSeqServiceImpl(SeqService unClassableSeqGen, ClassableSeqService classableSeqGen, LimitableSeqService limitableSeqGen, PatternResolver patternResolver) {
        this.unClassableSeqGen = unClassableSeqGen;
        this.classableSeqGen = classableSeqGen;
        this.limitSeqGen = limitableSeqGen;
        this.patternResolver = Optional.ofNullable(patternResolver).orElse(this.patternResolver);
    }

    public String getSequence() {
        return this.unClassableSeqGen.getSequence();
    }

    public String getSequence(String key) {
        return this.classableSeqGen.getSequence(key);
    }

    public String getLimitSequence(String key, Integer length) {
        return this.limitSeqGen.getLimitSequence(key, length);
    }

    public String getLimitSequence(String key, Long maxValue) {
        return this.limitSeqGen.getLimitSequence(key, maxValue);
    }

    public String getPatternedSequence(String patternStr) {
        PatternDescriptor resolved = this.patternResolver.resolve(patternStr);
        return this.doGetPatternedSequence(NO_KEY, resolved);
    }

    public String getPatternedSequence(PatternDescriptor descriptor) {
        PatternDescriptor resolved = this.patternResolver.resolve(descriptor);
        return this.doGetPatternedSequence(NO_KEY, resolved);
    }

    public String getPatternedSequence(String key, String patternStr, Integer seqLength) {
        PatternDescriptor resolved = this.patternResolver.resolve(patternStr, seqLength);
        return this.doGetPatternedSequence(key, resolved);
    }

    public String getPatternedSequence(String key, PatternDescriptor descriptor) {
        PatternDescriptor resolved = this.patternResolver.resolve(descriptor);
        return this.doGetPatternedSequence(key, resolved);
    }

    private String doGetPatternedSequence(String key, PatternDescriptor resolved) {
        String uid = key == NO_KEY ? this.getSequence() : (resolved.getSeqMaxValue() == null ? this.getSequence(key) : this.getLimitSequence(key, resolved.getSeqMaxValue()));
        return PatternDescriptorHelper.getSeqFromPatternAndUid((PatternDescriptor)resolved, (String)uid);
    }

    private static class InternalPatternResolver
    implements PatternResolver {
        private InternalPatternResolver() {
        }

        public PatternDescriptor resolve(String patternStr) {
            return this.resolve(patternStr, null);
        }

        public PatternDescriptor resolve(PatternDescriptor unResolved) {
            return this.resolve(unResolved.getOriginPatternString(), unResolved.getSeqLength());
        }

        public PatternDescriptor resolve(String patternStr, Integer seqLength) {
            LocalDateTime now = LocalDateTime.now();
            String resolvedString = patternStr.replace("$YEAR$", String.valueOf(now.getYear())).replace("$YE$", String.valueOf(now.getYear()).substring(2)).replace("$MONTH$", PatternDescriptorHelper.padZeroIfNecessary((String)String.valueOf(now.getMonth().getValue()), (Integer)2)).replace("$DAY$", PatternDescriptorHelper.padZeroIfNecessary((String)String.valueOf(now.getDayOfMonth()), (Integer)2)).replace("$HOUR$", PatternDescriptorHelper.padZeroIfNecessary((String)String.valueOf(now.getHour()), (Integer)2)).replace("$MIN$", PatternDescriptorHelper.padZeroIfNecessary((String)String.valueOf(now.getMinute()), (Integer)2)).replace("$SECOND$", PatternDescriptorHelper.padZeroIfNecessary((String)String.valueOf(now.getSecond()), (Integer)2));
            DefaultPatternDescriptor descriptor = new DefaultPatternDescriptor(resolvedString, "$", PatternDescriptorHelper.getMaxValueFromSeqLength((Integer)seqLength), seqLength);
            descriptor.setOriginPatternString(patternStr);
            return descriptor;
        }
    }
}

