/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.sequence.service.impl.support.redis;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisLockCluster {
    @Autowired
    private JedisPoolConfig jedisPoolConfig;
    private static String pre = "REDIS_LOCK:";
    @Value(value="${redis.maxIdle}")
    private int maxIdle;
    @Value(value="${redis.maxActive}")
    private int maxTotal;
    @Value(value="${redis.maxWaitMillis}")
    private int maxWaitMillis;
    @Value(value="${redis.hosts}")
    private String hosts;
    @Value(value="${redis.password}")
    private String password;
    @Value(value="${redis.timeout}")
    private int connectionTimeout;
    @Value(value="${redis.maxWait}")
    private int soTimeOut;
    @Value(value="${redis.maxAttempts}")
    private int maxAttempts;
    @Value(value="${redis.testOnBorrow}")
    private boolean testOnBorrow;

    private JedisCluster getJedisCluster() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxTotal(this.maxTotal);
        jedisPoolConfig.setMaxWaitMillis((long)this.maxWaitMillis);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        String[] hostArry = this.hosts.split(",");
        HashSet nodes = new HashSet();
        if (hostArry.length > 0) {
            Arrays.stream(hostArry).forEach(p -> {
                String[] detail = p.split(":");
                nodes.add(new HostAndPort(detail[0], Integer.parseInt(detail[1])));
            });
        }
        return new JedisCluster(nodes, this.connectionTimeout, this.soTimeOut, this.maxAttempts, this.password, (GenericObjectPoolConfig)jedisPoolConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryGetDistributedLock(String seriNo, String value, int expireTime) {
        JedisCluster jedisPool = null;
        try {
            jedisPool = this.getJedisCluster();
            String result = jedisPool.set(seriNo, value, "NX", "PX", (long)expireTime);
            if ("OK".equals(result)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                jedisPool.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseDistributedLock(String seriNo) {
        JedisCluster jedisPool = this.getJedisCluster();
        try {
            long result = jedisPool.del(seriNo);
            if (1L == result) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                jedisPool.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return false;
    }
}

