/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.sequence.service.impl.support.redis;

import com.irdstudio.basic.sequence.service.impl.support.redis.RedisLockCluster;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisSequenceGenerator {
    public static final String REDIS_SEQ_KEY_PREFIX = "SEQUENCE:";
    private static final String REDIS_KEY = "REDIS_SEQUENCE";
    private StringRedisTemplate template;
    private RedisLockCluster redisLockCluster;
    private Map<String, RedisAtomicLong> valueCache = new ConcurrentHashMap<String, RedisAtomicLong>(16);

    public RedisSequenceGenerator(StringRedisTemplate template, RedisLockCluster redisLockCluster) {
        this.template = template;
        this.redisLockCluster = redisLockCluster;
    }

    public Long getRedisSequence(String cls, Long maxValue) {
        String key = REDIS_SEQ_KEY_PREFIX + cls;
        RedisAtomicLong cached = this.valueCache.get(key);
        if (cached == null) {
            this.valueCache.putIfAbsent(key, new RedisAtomicLong(key, this.template.getConnectionFactory()));
            cached = this.valueCache.get(key);
        }
        long cur;
        while ((cur = cached.getAndIncrement()) > maxValue - maxValue / 10L) {
            long timeStamp = System.currentTimeMillis();
            Boolean b = this.redisLockCluster.tryGetDistributedLock(REDIS_KEY, String.valueOf(timeStamp), 4000);
            if (!b.booleanValue()) continue;
            if (cached.get() >= maxValue - maxValue / 10L) {
                cached.set(0L);
            }
            if (!((String)this.template.opsForValue().get((Object)REDIS_KEY)).equals(String.valueOf(timeStamp))) continue;
            this.redisLockCluster.releaseDistributedLock(REDIS_KEY);
        }
        return cur;
    }

    public void afterPropertiesSet() throws Exception {
        int threadNum = 2;
        CountDownLatch latch = new CountDownLatch(3);
        Runnable task = () -> {
            try {
                latch.countDown();
                latch.await();
                System.out.println(this.getRedisSequence("test", 1000L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        Thread[] threads = new Thread[2];
        for (int i = 0; i < 2; ++i) {
            threads[i] = new Thread(task);
            threads[i].start();
        }
        latch.countDown();
        for (Thread thread : threads) {
            thread.join();
        }
        System.out.println(this.getRedisSequence("test", 1000L));
    }

    public void setTemplate(StringRedisTemplate template) {
        this.template = template;
    }
}

