/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.sequence.service.impl;

import com.irdstudio.basic.framework.core.util.DateTool;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.basic.framework.core.util.TimeUtil;
import com.irdstudio.basic.sequence.service.facade.SequenceService;
import com.irdstudio.basic.sequence.service.impl.support.db.SAutoSeq;
import com.irdstudio.basic.sequence.service.impl.support.db.SequenceDao;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="sequenceServiceImpl")
public class SequenceServiceImpl
implements SequenceService {
    public static Map<String, Map<String, String>> templateMap = new ConcurrentHashMap<String, Map<String, String>>();
    private static Logger logger = LoggerFactory.getLogger(SequenceServiceImpl.class);
    private static String RESET_BY_DAY = "01";
    private static String RESET_BY_MONTH = "02";
    private static String RESET_BY_YEAR = "03";
    @Autowired
    private SequenceDao sequenceDao;
    @Autowired
    private StringRedisTemplate template;

    public String getSequence(String seqId, String orgCode, String prdCode, String legalCode, String areaCode) throws Exception {
        String startNum = this.sequenceDao.getSequenceSerno(seqId);
        List<String> seqNums = this.getSequences(seqId, orgCode, prdCode, legalCode, areaCode, 1, Integer.valueOf(startNum));
        logger.info("\u6d41\u6c34\u53f7ID\uff1a" + seqId + "\u751f\u6210\u7684\u6d41\u6c34\u53f7\u4e3a:" + seqNums.get(0));
        return seqNums.get(0);
    }

    public List<String> getSequences(String seqId, String orgCode, String prdCode, String legalCode, String areaCode, Integer seqNum) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("seqId", seqId);
        paramMap.put("seqNum", seqNum);
        String startNum = this.sequenceDao.getBatchSequenceSerno(paramMap);
        List<String> seqNums = this.getSequences(seqId, orgCode, prdCode, legalCode, areaCode, seqNum, Integer.valueOf(startNum));
        logger.info("\u6d41\u6c34\u53f7ID\uff1a" + seqId + "\u751f\u6210\u6570\u91cf:" + seqNum + "\u751f\u6210\u7684\u6279\u91cf\u6d41\u6c34\u53f7\u4e3a:" + seqNums);
        return seqNums;
    }

    private List<String> getSequences(String seqId, String orgCode, String prdCode, String legalCode, String areaCode, int seqNum, int startNum) {
        Map<String, String> template = templateMap.get(seqId);
        if (Objects.isNull(template) || template.isEmpty()) {
            SAutoSeq sAutoSeq = this.sequenceDao.querySAutoSeqBySeqId(seqId);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("sequencestyle", sAutoSeq.getSeqStyle());
            item.put("sequencelength", String.valueOf(sAutoSeq.getSeqLength()));
            templateMap.put(seqId, item);
            template = new HashMap<String, String>();
            template.putAll(item);
        }
        String seqStyle = template.get("sequencestyle");
        String seq_length = template.get("sequencelength");
        Calendar calendar = Calendar.getInstance();
        String openday = TimeUtil.getCurDate();
        String format = "HH:mm:ss";
        String hms = DateTool.getDate((String)format);
        Date date = DateTool.getDateFromLongStr((String)(openday + " " + hms));
        calendar.setTime(date);
        ArrayList<String> sequenceList = new ArrayList<String>();
        for (int i = 0; i < seqNum; ++i) {
            String cur_sernum = SequenceServiceImpl.numFormatToSeq(Integer.parseInt(seq_length), startNum + i);
            seqStyle = seqStyle.replace("$YEAR$", String.valueOf(calendar.get(1)));
            seqStyle = seqStyle.replace("$YE$", String.valueOf(calendar.get(1)).substring(2));
            seqStyle = seqStyle.replace("$MONTH$", SequenceServiceImpl.numFormatToSeq(2, calendar.get(2) + 1));
            seqStyle = seqStyle.replace("$DAY$", SequenceServiceImpl.numFormatToSeq(2, calendar.get(5)));
            seqStyle = seqStyle.replace("$ORG$", StringUtil.nullToEmpty((String)orgCode));
            seqStyle = seqStyle.replace("$LEGORG$", StringUtil.nullToEmpty((String)legalCode));
            seqStyle = seqStyle.replace("$AREA$", StringUtil.nullToEmpty((String)areaCode));
            seqStyle = seqStyle.replace("$PRD$", StringUtil.nullToEmpty((String)prdCode));
            seqStyle = seqStyle.replace("$SEQ$", cur_sernum);
            seqStyle = seqStyle.replace("$HOUR$", SequenceServiceImpl.numFormatToSeq(2, calendar.get(11)));
            seqStyle = seqStyle.replace("$MIN$", SequenceServiceImpl.numFormatToSeq(2, calendar.get(12)));
            seqStyle = seqStyle.replace("$SECOND$", SequenceServiceImpl.numFormatToSeq(2, calendar.get(13)));
            sequenceList.add(seqStyle);
            seqStyle = template.get("sequencestyle");
        }
        return sequenceList;
    }

    private static String numFormatToSeq(int len, int value) {
        if (len <= 0) {
            return "";
        }
        StringBuffer seq = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            seq.append('0');
        }
        seq.append(value);
        return seq.substring(seq.length() - len);
    }

    public String getSequence(String seqId, String orgCode, String prdCode) throws Exception {
        return this.getSequence(seqId, orgCode, prdCode, null, null);
    }

    public List<String> getSequences(String seqId, String orgCode, String prdCode, Integer seqNum) throws Exception {
        return this.getSequences(seqId, orgCode, prdCode, null, null, seqNum);
    }

    public int resetSequence(String openday) {
        try {
            String lastOpenday = TimeUtil.getYesterday((String)openday);
            logger.info("\u5f00\u59cb\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u65e5\u91cd\u7f6e\u3011\u7684\u5e8f\u5217......");
            int count = this.sequenceDao.resetSeq(RESET_BY_DAY, openday, lastOpenday);
            logger.info("\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u65e5\u91cd\u7f6e\u3011\u7684\u5e8f\u5217\u8bb0\u5f55\u6570\uff1a" + count);
            logger.info("\u5f00\u59cb\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u6708\u91cd\u7f6e\u3011\u7684\u5e8f\u5217......");
            if (openday.endsWith("01")) {
                count = this.sequenceDao.resetSeq(RESET_BY_MONTH, openday, null);
                logger.info("\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u6708\u91cd\u7f6e\u3011\u7684\u5e8f\u5217\u8bb0\u5f55\u6570\uff1a" + count);
            } else {
                logger.error("\u672a\u5230\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u6708\u91cd\u7f6e\u3011\u7684\u5e8f\u5217\u7684\u65f6\u95f4\uff01");
            }
            logger.info("\u5f00\u59cb\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u5e74\u91cd\u7f6e\u3011\u7684\u5e8f\u5217......");
            if (openday.endsWith("01-01")) {
                count = this.sequenceDao.resetSeq(RESET_BY_YEAR, openday, null);
                logger.info("\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u5e74\u91cd\u7f6e\u3011\u7684\u5e8f\u5217\u8bb0\u5f55\u6570\uff1a" + count);
            } else {
                logger.error("\u672a\u5230\u91cd\u7f6e\u9891\u7387\u4e3a\u3010\u6bcf\u5e74\u91cd\u7f6e\u3011\u7684\u5e8f\u5217\u7684\u65f6\u95f4\uff01");
            }
            this.sequenceDao.setLastResetDate(openday);
            this.template.opsForValue().set((Object)"openday", (Object)openday);
        }
        catch (Exception e) {
            logger.error("\u91cd\u7f6e\u5e8f\u5217\u53f7\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return 0;
    }

    public String getOpenday() {
        String openday = (String)this.template.opsForValue().get((Object)"openday");
        return openday;
    }
}

