/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.basic.sequence.service.impl.support.snowflake.worker;

import com.irdstudio.basic.sequence.service.impl.support.snowflake.utils.DockerUtils;
import com.irdstudio.basic.sequence.service.impl.support.snowflake.utils.NetUtils;
import com.irdstudio.basic.sequence.service.impl.support.snowflake.worker.WorkerIdAssigner;
import com.irdstudio.basic.sequence.service.impl.support.snowflake.worker.WorkerNodeType;
import com.irdstudio.basic.sequence.service.impl.support.snowflake.worker.dao.WorkerNodeDAO;
import com.irdstudio.basic.sequence.service.impl.support.snowflake.worker.entity.WorkerNodeEntity;
import javax.annotation.Resource;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DisposableWorkerIdAssigner
implements WorkerIdAssigner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisposableWorkerIdAssigner.class);
    @Resource
    private WorkerNodeDAO workerNodeDAO;

    @Override
    @Transactional
    public long assignWorkerId() {
        WorkerNodeEntity workerNodeEntity = this.buildWorkerNode();
        this.workerNodeDAO.addWorkerNode(workerNodeEntity);
        LOGGER.info("Add worker node:" + workerNodeEntity);
        return workerNodeEntity.getId();
    }

    private WorkerNodeEntity buildWorkerNode() {
        WorkerNodeEntity workerNodeEntity = new WorkerNodeEntity();
        if (DockerUtils.isDocker()) {
            workerNodeEntity.setType(WorkerNodeType.CONTAINER.value());
            workerNodeEntity.setHostName(DockerUtils.getDockerHost());
            workerNodeEntity.setPort(DockerUtils.getDockerPort());
        } else {
            workerNodeEntity.setType(WorkerNodeType.ACTUAL.value());
            workerNodeEntity.setHostName(NetUtils.getLocalAddress());
            workerNodeEntity.setPort(System.currentTimeMillis() + "-" + RandomUtils.nextInt((int)100000));
        }
        return workerNodeEntity;
    }
}

