/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.alibaba.fastjson.JSONObject;
import com.irdstudio.bfp.console.service.facade.BpmBaseInfoService;
import com.irdstudio.bfp.console.service.facade.SAgentInfoService;
import com.irdstudio.bfp.console.service.vo.BpmBaseInfoVO;
import com.irdstudio.bfp.console.utils.BpmAgentUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.util.StringUtil;
import com.irdstudio.sdk.ssm.vo.ResponseVO;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BpmBaseInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="bpmBaseInfoServiceImpl")
    private BpmBaseInfoService bpmBaseInfoService;
    @Autowired
    @Qualifier(value="sAgentInfoService")
    private SAgentInfoService sAgentInfoService;

    @RequestMapping(value={"/bpm/base/infos/{bpmType}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpmBaseInfoVO>> queryBpmBaseInfoAll(@PathVariable(value="bpmType") String bpmType, BpmBaseInfoVO vo) {
        vo.setBpmType(bpmType);
        List<BpmBaseInfoVO> outputVo = this.bpmBaseInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/base/info/{bpmId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpmBaseInfoVO> queryByPk(@PathVariable(value="bpmId") String bpmId) {
        BpmBaseInfoVO inVo = new BpmBaseInfoVO();
        inVo.setBpmId(bpmId);
        BpmBaseInfoVO outputVo = this.bpmBaseInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bpm/base/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpmBaseInfoVO inBpmBaseInfoVo) {
        int outputVo = this.bpmBaseInfoService.deleteByPk(inBpmBaseInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/base/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpmBaseInfoVO inBpmBaseInfoVo) {
        int outputVo = this.bpmBaseInfoService.updateByPk(inBpmBaseInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/base/info"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer insertBpmBaseInfo(@RequestBody BpmBaseInfoVO inBpmBaseInfoVo) {
        int outputVo = this.bpmBaseInfoService.insertBpmBaseInfo(inBpmBaseInfoVo);
        return outputVo;
    }

    @RequestMapping(value={"/bpm/base/infos/flowdata/{bpmId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> queryBpmBaseInfoFlowData(@PathVariable(value="bpmId") String bpmId) {
        Map<String, Object> res = this.bpmBaseInfoService.queryBpmBaseInfoFlowData(bpmId);
        return this.getResponseData(res);
    }

    @RequestMapping(value={"/bpm/base/infos/flowdata"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> queryBpmBaseInfoFlowData(@RequestBody Map<String, Object> flowData) {
        Boolean res = this.bpmBaseInfoService.saveBpmBaseInfoFlowData(flowData);
        return this.getResponseData(res);
    }

    @RequestMapping(value={"/bpm/base/publish"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> publishAutoFlow(@RequestBody BpmBaseInfoVO inBpmBaseInfoVo) {
        Boolean res = this.bpmBaseInfoService.publishAutoFlow(inBpmBaseInfoVo);
        return this.getResponseData(res);
    }

    @RequestMapping(value={"/wfi/flow/publish"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> publishWfiFlow(@RequestBody BpmBaseInfoVO inBpmBaseInfoVo) {
        Boolean res = this.bpmBaseInfoService.publishWfiFlow(inBpmBaseInfoVo);
        return this.getResponseData(res);
    }

    @RequestMapping(value={"/bpm/batch/info/test"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Boolean> startBatch(@RequestBody Map<String, Object> params) {
        String jsonData = params.get("jsonData").toString();
        jsonData = jsonData.replaceAll("\\{", "").replaceAll("\\}", "");
        String bpmId = "";
        HashMap<String, String> map = new HashMap<String, String>();
        String[] split = jsonData.split("\\,");
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            String[] split2 = str.split("\\=");
            if ("bpmId".equals(split2[0].trim())) {
                bpmId = split2[1].trim();
                continue;
            }
            if ("bpmName".equals(split2[0].trim())) continue;
            map.put(split2[0].trim(), split2[1].trim());
        }
        Object paramsRequest = JSONObject.toJSON(map);
        BpmBaseInfoVO bpmBaseInfoVO = new BpmBaseInfoVO();
        bpmBaseInfoVO.setBpmId(bpmId);
        BpmBaseInfoVO batchConf = this.bpmBaseInfoService.queryByPk(bpmBaseInfoVO);
        ResponseData data = null;
        String agentUrl = "http://127.0.0.1:8080/smcenter-agent/agent";
        try {
            String wfiSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
            ResponseVO response = BpmAgentUtil.actionBpm(agentUrl, wfiSerialNo, bpmId, paramsRequest.toString());
            if (response != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                data = this.getResponseData(true);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01");
                    logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01\u5ba1\u6279\u6d41\u7a0b\u53f7\uff1a" + bpmId + "\uff0c\u5ba1\u6279\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + wfiSerialNo);
                }
            } else {
                data = this.getResponseData(false);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u5ba1\u6279\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
        }
        return null;
    }
}

