/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.irdstudio.bfp.console.service.facade.BpmNodeInfoService;
import com.irdstudio.bfp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.bfp.console.service.vo.PluginParamConfVO;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BpmNodeInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="bpmNodeInfoServiceImpl")
    private BpmNodeInfoService bpmNodeInfoService;

    @RequestMapping(value={"/bpm/node/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpmNodeInfoVO>> queryBpmNodeInfoAll(BpmNodeInfoVO vo) {
        List<BpmNodeInfoVO> outputVo = this.bpmNodeInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/node/info/{bpmNodeId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpmNodeInfoVO> queryByPk(@PathVariable(value="bpmNodeId") String bpmNodeId) {
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO outputVo = this.bpmNodeInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bpm/node/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpmNodeInfoVO inBpmNodeInfoVo) {
        int outputVo = this.bpmNodeInfoService.deleteByPk(inBpmNodeInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/node/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpmNodeInfoVO inBpmNodeInfoVo) {
        int outputVo = this.bpmNodeInfoService.updateByPk(inBpmNodeInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/node/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpmNodeInfo(@RequestBody BpmNodeInfoVO inBpmNodeInfoVo) {
        int outputVo = this.bpmNodeInfoService.insertBpmNodeInfo(inBpmNodeInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bpm/node/info2"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpmNodeInfo2(@RequestBody BpmNodeInfoVO inBpmNodeInfoVo) {
        inBpmNodeInfoVo.setBpmNodeId(KeyUtil.createUUIDKey());
        int outputVo = this.bpmNodeInfoService.insertBpmNodeInfo(inBpmNodeInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/save/plugin/param"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> savePluginParam(@RequestBody Map<String, Object> params) {
        int outputVo = 0;
        String bpmNodeId = params.get("bpmNodeId").toString();
        HashMap paramMap = (HashMap)params.get("bpmNodeParam");
        String bpmNodeParam = JSONUtils.toJSONString((Object)paramMap);
        logger.info(bpmNodeParam);
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO checkResult = this.bpmNodeInfoService.queryByPk(inVo);
        String oldNodeParam = checkResult.getBpmNodeParam();
        if (StringUtils.isNotBlank((String)oldNodeParam)) {
            JSONObject oldParamJson = JSONObject.parseObject((String)oldNodeParam, (Feature[])new Feature[]{Feature.OrderedField});
            oldParamJson.putAll((Map)paramMap);
            bpmNodeParam = oldParamJson.toString();
        }
        inVo.setBpmNodeParam(bpmNodeParam);
        outputVo = this.bpmNodeInfoService.updateByPk(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/confs/{bpmNodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginParamConfVO>> queryNodeParamByPluginId(@PathVariable(value="bpmNodeId") String bpmNodeId, PluginParamConfVO inPluginParamConfVO) {
        ArrayList<PluginParamConfVO> paramList = new ArrayList<PluginParamConfVO>();
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO bpmNodeInfoVO = this.bpmNodeInfoService.queryByPk(inVo);
        String bpmNodeParam = bpmNodeInfoVO.getBpmNodeParam();
        if (StringUtils.isNotBlank((String)bpmNodeParam)) {
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)bpmNodeParam, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[0]);
            for (Map.Entry entry : jsonMap.entrySet()) {
                PluginParamConfVO vo = new PluginParamConfVO();
                vo.setPluginId(bpmNodeId);
                vo.setParaName((String)entry.getKey());
                vo.setParaValue((String)entry.getValue());
                paramList.add(vo);
            }
        }
        return this.getResponseData(paramList);
    }

    @RequestMapping(value={"/delete/plugin/param/{bpmNodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> deleteNodeParamByPluginId(@PathVariable(value="bpmNodeId") String bpmNodeId) {
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        int outputVo = this.bpmNodeInfoService.deleteNodeParam(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/plugin/param/confs/grid/{bpmNodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<String> queryNodeParamForGrid(@PathVariable(value="bpmNodeId") String bpmNodeId) {
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO bpmNodeInfoVO = this.bpmNodeInfoService.queryByPk(inVo);
        String bpmNodeParam = bpmNodeInfoVO.getBpmNodeParam();
        return this.getResponseData(bpmNodeParam);
    }

    @RequestMapping(value={"/save/plugin/param/grid"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> savePluginParamGrid(@RequestBody Map<String, Object> params) {
        int outputVo = 0;
        String bpmNodeId = params.get("bpmNodeId").toString();
        String paramCode = params.get("paramCode").toString();
        HashMap paramMap = (HashMap)params.get("bpmNodeParam");
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO checkResult = this.bpmNodeInfoService.queryByPk(inVo);
        String oldNodeParam = checkResult.getBpmNodeParam();
        if (StringUtils.isNotBlank((String)oldNodeParam)) {
            JSONArray paramArray = (JSONArray)JSONObject.parseObject((String)oldNodeParam, (Feature[])new Feature[]{Feature.OrderedField}).get((Object)paramCode);
            JSONObject oldParamJson = JSONObject.parseObject((String)oldNodeParam, (Feature[])new Feature[]{Feature.OrderedField});
            if (paramArray == null) {
                JSONArray newParamArray = new JSONArray();
                newParamArray.add((Object)paramMap);
                oldParamJson.put(paramCode, (Object)newParamArray);
            } else {
                paramArray.add((Object)paramMap);
                oldParamJson.put(paramCode, (Object)paramArray);
            }
            inVo.setBpmNodeParam(oldParamJson.toString());
        } else {
            JSONObject newParamJson = new JSONObject();
            JSONArray newParamArray = new JSONArray();
            newParamArray.add((Object)paramMap);
            newParamJson.put(paramCode, (Object)newParamArray);
            inVo.setBpmNodeParam(newParamJson.toString());
        }
        outputVo = this.bpmNodeInfoService.updateByPk(inVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/update/plugin/param/grid"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> updatePluginParamGrid(@RequestBody Map<String, Object> params) {
        String nodeParam;
        int outputVo = 0;
        String bpmNodeId = params.get("bpmNodeId").toString();
        String paramCode = params.get("paramCode").toString();
        HashMap paramMap = (HashMap)params.get("bpmNodeParam");
        String newNodeParam = JSONUtils.toJSONString((Object)paramMap);
        logger.info(newNodeParam);
        String oldNodeParam = null;
        try {
            oldNodeParam = URLDecoder.decode(params.get("oldNodeParam").toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JsonParser parser = new JsonParser();
        JsonObject oldParamJson = (JsonObject)parser.parse(oldNodeParam);
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO checkResult = this.bpmNodeInfoService.queryByPk(inVo);
        if (checkResult != null && StringUtils.isNotBlank((String)(nodeParam = checkResult.getBpmNodeParam()))) {
            JsonArray jsonArray = new JsonParser().parse(nodeParam).getAsJsonObject().getAsJsonArray(paramCode);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject srcJson = jsonArray.get(i).getAsJsonObject();
                if (!oldParamJson.equals((Object)srcJson)) continue;
                jsonArray.set(i, (JsonElement)new JsonParser().parse(newNodeParam).getAsJsonObject());
            }
            JsonObject oldParam = (JsonObject)new JsonParser().parse(nodeParam);
            oldParam.remove(paramCode);
            oldParam.add(paramCode, (JsonElement)jsonArray);
            inVo.setBpmNodeParam(oldParam.toString());
            outputVo = this.bpmNodeInfoService.updateByPk(inVo);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/delete/plugin/param/grid"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> deletePluginParamGrid(@RequestBody Map<String, Object> params) {
        String nodeParam;
        int outputVo = 0;
        String bpmNodeId = params.get("bpmNodeId").toString();
        String paramCode = params.get("paramCode").toString();
        HashMap paramMap = (HashMap)params.get("bpmNodeParam");
        String newNodeParam = JSONUtils.toJSONString((Object)paramMap);
        logger.info(newNodeParam);
        String oldNodeParam = null;
        try {
            oldNodeParam = URLDecoder.decode(params.get("oldNodeParam").toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JsonParser parser = new JsonParser();
        JsonObject oldParamJson = (JsonObject)parser.parse(oldNodeParam);
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO checkResult = this.bpmNodeInfoService.queryByPk(inVo);
        if (checkResult != null && StringUtils.isNotBlank((String)(nodeParam = checkResult.getBpmNodeParam()))) {
            JsonArray jsonArray = new JsonParser().parse(nodeParam).getAsJsonObject().getAsJsonArray(paramCode);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject srcJson = jsonArray.get(i).getAsJsonObject();
                if (!oldParamJson.equals((Object)srcJson)) continue;
                jsonArray.remove(i);
            }
            JsonObject oldParam = (JsonObject)new JsonParser().parse(nodeParam);
            oldParam.remove(paramCode);
            oldParam.add(paramCode, (JsonElement)jsonArray);
            inVo.setBpmNodeParam(oldParam.toString());
            outputVo = this.bpmNodeInfoService.updateByPk(inVo);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/get/param/value/grid"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<PluginParamConfVO>> getNodeParamGrid(@RequestBody Map<String, Object> params) {
        String bpmNodeId = params.get("bpmNodeId").toString();
        String paramCode = params.get("paramCode").toString();
        String row = null;
        try {
            row = URLDecoder.decode(params.get("row").toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        JsonParser parser = new JsonParser();
        JsonObject rowJson = (JsonObject)parser.parse(row);
        ArrayList<PluginParamConfVO> paramList = new ArrayList<PluginParamConfVO>();
        BpmNodeInfoVO inVo = new BpmNodeInfoVO();
        inVo.setBpmNodeId(bpmNodeId);
        BpmNodeInfoVO bpmNodeInfoVO = this.bpmNodeInfoService.queryByPk(inVo);
        String bpmNodeParam = bpmNodeInfoVO.getBpmNodeParam();
        if (StringUtils.isNotBlank((String)bpmNodeParam)) {
            String result = "";
            JsonArray jsonArray = new JsonParser().parse(bpmNodeParam).getAsJsonObject().getAsJsonArray(paramCode);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject srcJson = jsonArray.get(i).getAsJsonObject();
                if (!rowJson.equals((Object)srcJson)) continue;
                result = srcJson.toString();
            }
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)result, (TypeReference)new TypeReference<LinkedHashMap<String, String>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            for (Map.Entry entry : jsonMap.entrySet()) {
                PluginParamConfVO vo = new PluginParamConfVO();
                vo.setPluginId(bpmNodeId);
                vo.setParaName((String)entry.getKey());
                vo.setParaValue((String)entry.getValue());
                paramList.add(vo);
            }
        }
        return this.getResponseData(paramList);
    }
}

