/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.api.rest;

import com.irdstudio.bfp.console.dao.domain.SubsCodeBase;
import com.irdstudio.bfp.console.service.facade.BpaBaseInfoService;
import com.irdstudio.bfp.console.service.facade.SAgentInfoService;
import com.irdstudio.bfp.console.service.facade.SSrvsCronConfService;
import com.irdstudio.bfp.console.service.vo.BpaBaseInfoVO;
import com.irdstudio.bfp.console.service.vo.SAgentInfoVO;
import com.irdstudio.bfp.console.service.vo.SSrvsCronConfVO;
import com.irdstudio.bfp.console.utils.BpaAgentUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.util.StringUtil;
import com.irdstudio.sdk.ssm.vo.ResponseVO;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BpaBaseInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="batchConfigService")
    private BpaBaseInfoService bpaBaseInfoService;
    @Autowired
    @Qualifier(value="sSrvsCronConfService")
    private SSrvsCronConfService sSrvsCronConfService;
    @Autowired
    @Qualifier(value="sAgentInfoService")
    private SAgentInfoService sAgentInfoService;

    @RequestMapping(value={"/bat/batch/info/configs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<BpaBaseInfoVO>> queryBpaBaseInfoAll(BpaBaseInfoVO vo) {
        List<BpaBaseInfoVO> outputVo = this.bpaBaseInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config/{bpaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<BpaBaseInfoVO> queryByPk(@PathVariable(value="bpaId") String bpaId) {
        BpaBaseInfoVO inVo = new BpaBaseInfoVO();
        inVo.setBpaId(bpaId);
        BpaBaseInfoVO outputVo = this.bpaBaseInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody BpaBaseInfoVO inBpaBaseInfoVo) {
        int outputVo = this.bpaBaseInfoService.deleteByPk(inBpaBaseInfoVo);
        if (outputVo == 1) {
            SSrvsCronConfVO paramVO = new SSrvsCronConfVO();
            paramVO.setJobCode(inBpaBaseInfoVo.getBpaId());
            this.sSrvsCronConfService.deleteByPk(paramVO);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody BpaBaseInfoVO inBpaBaseInfoVo) throws Exception {
        int outputVo = this.bpaBaseInfoService.updateByPk(inBpaBaseInfoVo);
        if (outputVo == 1) {
            SSrvsCronConfVO paramVO = new SSrvsCronConfVO();
            paramVO.setJobCode(inBpaBaseInfoVo.getBpaId());
            SSrvsCronConfVO confVO = this.sSrvsCronConfService.queryByPk(paramVO);
            int count = 1;
            if (confVO != null && (count = this.sSrvsCronConfService.deleteByPk(paramVO)) != 1) {
                ResponseData data = this.getResponseData(count);
                data.setMessage("\u5220\u9664\u5b9a\u65f6\u8c03\u5ea6\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff01\u64cd\u4f5c\u5f71\u54cd\u4e86" + count + "\u6761\u8bb0\u5f55");
                return data;
            }
            if (count == 1 && inBpaBaseInfoVo.getLaunchType() != null && "1".equals(inBpaBaseInfoVo.getLaunchType())) {
                SSrvsCronConfVO addConfVO = new SSrvsCronConfVO();
                addConfVO.setJobCode(inBpaBaseInfoVo.getBpaId());
                addConfVO.setJobDesc(inBpaBaseInfoVo.getBpaName());
                addConfVO.setCronExpression(inBpaBaseInfoVo.getBpaCronValue());
                addConfVO.setAgentId(inBpaBaseInfoVo.getAgentId());
                addConfVO.setAgainTime(3);
                addConfVO.setRetrySecond(60);
                if (confVO != null) {
                    addConfVO.setJobClassType(confVO.getJobClassType());
                    addConfVO.setJobClass(confVO.getJobClass());
                    addConfVO.setJobMethod(confVO.getJobMethod());
                    addConfVO.setJobDesc(confVO.getJobDesc());
                }
                this.sSrvsCronConfService.insertSSrvsCronConf(addConfVO);
            }
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/change/subs/code"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateBySubsCode(@RequestBody SubsCodeBase subsCodeBase) {
        int outputVo = this.bpaBaseInfoService.updateBySubsCode(subsCodeBase);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/config"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertBpaBaseInfo(@RequestBody BpaBaseInfoVO inBpaBaseInfoVo) {
        int outputVo = this.bpaBaseInfoService.insertBpaBaseInfo(inBpaBaseInfoVo);
        if (outputVo == 1 && inBpaBaseInfoVo.getLaunchType() != null && "1".equals(inBpaBaseInfoVo.getLaunchType())) {
            SSrvsCronConfVO addConfVO = new SSrvsCronConfVO();
            addConfVO.setJobCode(inBpaBaseInfoVo.getBpaId());
            addConfVO.setJobDesc(inBpaBaseInfoVo.getBpaName());
            addConfVO.setCronExpression(inBpaBaseInfoVo.getBpaCronValue());
            addConfVO.setAgentId(inBpaBaseInfoVo.getAgentId());
            addConfVO.setAgainTime(3);
            addConfVO.setRetrySecond(60);
            this.sSrvsCronConfService.insertSSrvsCronConf(addConfVO);
        }
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/bat/batch/info/action/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> startBatch(@RequestParam(value="bpaSerialNo") String bpaSerialNo, @RequestParam(value="bpaId") String bpaId, @RequestParam(value="bpmCode") String bpmCode, @RequestParam(value="bpmVersion") String bpmVersion, @RequestParam(value="batchAction") String batchAction) {
        ResponseData data;
        block9: {
            BpaBaseInfoVO params = new BpaBaseInfoVO();
            params.setBpaId(bpaId);
            BpaBaseInfoVO batchConf = this.bpaBaseInfoService.queryByPk(params);
            SAgentInfoVO inVo = new SAgentInfoVO();
            inVo.setAgentId(batchConf.getAgentId());
            SAgentInfoVO agentInfo = this.sAgentInfoService.queryByPk(inVo);
            data = null;
            if (agentInfo != null && StringUtil.isNotEmpty((String)agentInfo.getAgentUrl())) {
                try {
                    ResponseVO response;
                    if ("none".equals(bpaSerialNo)) {
                        bpaSerialNo = TimeUtil.getTimeStampByPattern((String)"yyyyMMddHHmmssSSS");
                    }
                    if ((response = BpaAgentUtil.actionBpa(agentInfo.getAgentUrl(), bpaSerialNo, bpmCode, bpmVersion, batchAction)) != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(true);
                        if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01");
                            logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01agentId:" + agentInfo.getAgentId() + ", agent\u5730\u5740\uff1a" + agentInfo.getAgentUrl() + ", \u81ea\u52a8\u6d41\u7a0b\u53f7\uff1a" + bpaId + ", \u81ea\u52a8\u6d41\u7a0b\u7248\u672c\uff1a" + bpmVersion + "\uff0c\u81ea\u52a8\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + bpaSerialNo);
                        }
                        break block9;
                    }
                    data = this.getResponseData(false);
                    if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block9;
                    }
                    data.setMessage("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(false);
                    data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentInfo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f");
                data = this.getResponseData(false);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            }
        }
        return data;
    }

    @RequestMapping(value={"/bat/bpm/batch/info/action/"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> startBpmBatch(@RequestParam(value="bpaSerialNo") String bpaSerialNo, @RequestParam(value="bpaId") String bpaId, @RequestParam(value="bpmCode") String bpmCode, @RequestParam(value="bpmVersion") String bpmVersion, @RequestParam(value="batchAction") String batchAction) {
        String agentUrl = PropertiesUtil.getPropertyByKey((String)"application", (String)"bpm.agent.url");
        ResponseData data = null;
        try {
            ResponseVO response = BpaAgentUtil.actionBpa(agentUrl, bpaSerialNo, bpmCode, bpmVersion, batchAction);
            if (response != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                data = this.getResponseData(true);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u4e1a\u52a1\u6d41\u8f6c\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01");
                    logger.info(bpaSerialNo + "\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u6210\u529f\uff01agent\u5730\u5740\uff1a" + agentUrl + ", \u81ea\u52a8\u6d41\u7a0b\u53f7\uff1a" + bpaId + ", \u81ea\u52a8\u6d41\u7a0b\u6d41\u6c34\u53f7\uff1a" + bpaSerialNo + ", \u81ea\u52a8\u6d41\u7a0b\u52a8\u4f5c\uff1a" + batchAction);
                }
            } else {
                data = this.getResponseData(false);
                if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                    data.setMessage(response.getMsg());
                    logger.info(response.getMsg());
                } else {
                    data.setMessage("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                    logger.info("\u81ea\u52a8\u6d41\u7a0b\u6267\u884c\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl, (Throwable)e);
            data = this.getResponseData(false);
            data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + agentUrl);
        }
        return data;
    }
}

