/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.service.impl;

import com.irdstudio.bfp.console.dao.BpaInstTaskDao;
import com.irdstudio.bfp.console.dao.BpmBpaInstTaskDao;
import com.irdstudio.bfp.console.dao.domain.BpaInstTask;
import com.irdstudio.bfp.console.service.facade.BpaInstTaskService;
import com.irdstudio.bfp.console.service.vo.BpaInstTaskTree;
import com.irdstudio.bfp.console.service.vo.BpaInstTaskVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="instTaskService")
public class BpaInstTaskServiceImpl
implements BpaInstTaskService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BpaInstTaskServiceImpl.class);
    @Autowired
    private BpaInstTaskDao bpaInstTaskDao;
    @Autowired
    private BpmBpaInstTaskDao bpmbpaInstTaskDao;

    @Override
    public int insertBpaInstTask(BpaInstTaskVO inBpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpaInstTaskVo.toString());
        int num = 0;
        try {
            BpaInstTask bpaInstTask = new BpaInstTask();
            this.beanCopy((Object)inBpaInstTaskVo, (Object)bpaInstTask);
            num = this.bpaInstTaskDao.insertBpaInstTask(bpaInstTask);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(BpaInstTaskVO inBpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpaInstTaskVo));
        int num = 0;
        try {
            BpaInstTask bpaInstTask = new BpaInstTask();
            this.beanCopy((Object)inBpaInstTaskVo, (Object)bpaInstTask);
            num = this.bpaInstTaskDao.deleteByPk(bpaInstTask);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpaInstTaskVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BpaInstTaskVO inBpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpaInstTaskVo.toString());
        int num = 0;
        try {
            BpaInstTask bpaInstTask = new BpaInstTask();
            this.beanCopy((Object)inBpaInstTaskVo, (Object)bpaInstTask);
            num = this.bpaInstTaskDao.updateByPk(bpaInstTask);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpaInstTaskVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public BpaInstTaskVO queryByPk(BpaInstTaskVO inBpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBpaInstTaskVo));
        try {
            BpaInstTask queryBpaInstTask = new BpaInstTask();
            this.beanCopy((Object)inBpaInstTaskVo, (Object)queryBpaInstTask);
            BpaInstTask queryRslBpaInstTask = this.bpaInstTaskDao.queryByPk(queryBpaInstTask);
            if (Objects.nonNull((Object)queryRslBpaInstTask)) {
                BpaInstTaskVO outBpaInstTaskVo = (BpaInstTaskVO)((Object)this.beanCopy((Object)queryRslBpaInstTask, (Object)new BpaInstTaskVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBpaInstTaskVo.toString());
                return outBpaInstTaskVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BpaInstTaskVO> queryAllOwner(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpaInstTask> bpaInstTasks = this.bpaInstTaskDao.queryAllOwnerByPage(bpaInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpaInstTasks.size());
            this.pageSet(bpaInstTasks, bpaInstTaskVo);
            list = (List)this.beansCopy(bpaInstTasks, BpaInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpaInstTaskVO> queryAllCurrOrg(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpaInstTask> bpaInstTasks = this.bpaInstTaskDao.queryAllCurrOrgByPage(bpaInstTaskVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpaInstTasks.size());
        List list = null;
        try {
            this.pageSet(bpaInstTasks, bpaInstTaskVo);
            list = (List)this.beansCopy(bpaInstTasks, BpaInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpaInstTaskVO> queryAllCurrDownOrg(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpaInstTask> bpaInstTasks = this.bpaInstTaskDao.queryAllCurrDownOrgByPage(bpaInstTaskVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpaInstTasks.size());
        List list = null;
        try {
            this.pageSet(bpaInstTasks, bpaInstTaskVo);
            list = (List)this.beansCopy(bpaInstTasks, BpaInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpaInstTaskTree> queryBpaInstTaskTree(BpaInstTaskVO bpaInstTaskVo) {
        ArrayList<BpaInstTaskTree> taskTree = new ArrayList<BpaInstTaskTree>();
        String text = bpaInstTaskVo.getBpaId() + "(" + bpaInstTaskVo.getBpaSerialNo() + ")";
        BpaInstTaskTree root = new BpaInstTaskTree(bpaInstTaskVo.getBpaSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BpaInstTask> bpaInstTasks = this.bpaInstTaskDao.queryAllInstTask(bpaInstTaskVo);
        for (int i = 0; i < bpaInstTasks.size(); ++i) {
            BpaInstTaskTree stageNode;
            BpaInstTask task = bpaInstTasks.get(i);
            BpaInstTaskTree<BpaInstTask> taskNode = new BpaInstTaskTree<BpaInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BpaInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BpaInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public int updateTaskInterveneState(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u4e3a:" + bpaInstTaskVo.toString());
        int num = 0;
        try {
            BpaInstTask bpaInstTask = new BpaInstTask();
            this.beanCopy((Object)bpaInstTaskVo, (Object)bpaInstTask);
            num = this.bpaInstTaskDao.updateTaskInterveneState(bpaInstTask);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)bpaInstTaskVo) + "\u4fee\u6539\u7684\u4eba\u5de5\u5e72\u9884\u72b6\u6001\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public List<BpaInstTaskTree> queryBpmBpaInstTaskTree(BpaInstTaskVO bpaInstTaskVo) {
        ArrayList<BpaInstTaskTree> taskTree = new ArrayList<BpaInstTaskTree>();
        String text = bpaInstTaskVo.getBpaId() + "(" + bpaInstTaskVo.getBpaSerialNo() + ")";
        BpaInstTaskTree root = new BpaInstTaskTree(bpaInstTaskVo.getBpaSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BpaInstTask> bpaInstTasks = this.bpmbpaInstTaskDao.queryBpmAllInstTask(bpaInstTaskVo);
        for (int i = 0; i < bpaInstTasks.size(); ++i) {
            BpaInstTaskTree stageNode;
            BpaInstTask task = bpaInstTasks.get(i);
            BpaInstTaskTree<BpaInstTask> taskNode = new BpaInstTaskTree<BpaInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BpaInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BpaInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public List<BpaInstTaskTree> queryBpmBpaInstTaskHisTree(BpaInstTaskVO bpaInstTaskVo) {
        ArrayList<BpaInstTaskTree> taskTree = new ArrayList<BpaInstTaskTree>();
        String text = bpaInstTaskVo.getBpaId() + "(" + bpaInstTaskVo.getBpaSerialNo() + ")";
        BpaInstTaskTree root = new BpaInstTaskTree(bpaInstTaskVo.getBpaSerialNo(), text);
        taskTree.add(root);
        HashMap stageMap = new HashMap();
        List<BpaInstTask> bpaInstTasks = this.bpmbpaInstTaskDao.queryBpmAllInstTaskHis(bpaInstTaskVo);
        for (int i = 0; i < bpaInstTasks.size(); ++i) {
            BpaInstTaskTree stageNode;
            BpaInstTask task = bpaInstTasks.get(i);
            BpaInstTaskTree<BpaInstTask> taskNode = new BpaInstTaskTree<BpaInstTask>(task.getTaskId(), task.getTaskName());
            taskNode.setAttributes(task);
            taskNode.setIconCls("task-tree-icon");
            if (!stageMap.containsKey(task.getStageId())) {
                stageNode = new BpaInstTaskTree(task.getStageId(), task.getStageName());
                stageNode.getChildren().add(taskNode);
                root.getChildren().add(stageNode);
                stageMap.put(task.getStageId(), stageNode);
                continue;
            }
            stageNode = (BpaInstTaskTree)((Object)stageMap.get(task.getStageId()));
            stageNode.getChildren().add(taskNode);
        }
        return taskTree;
    }

    @Override
    public List<BpaInstTaskVO> queryBpmAllOwner(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpaInstTask> bpaInstTasks = this.bpmbpaInstTaskDao.queryBpmAllOwnerByPage(bpaInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpaInstTasks.size());
            this.pageSet(bpaInstTasks, bpaInstTaskVo);
            list = (List)this.beansCopy(bpaInstTasks, BpaInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpaInstTaskVO> queryBpmHisAllOwner(BpaInstTaskVO bpaInstTaskVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpaInstTask> bpaInstTasks = this.bpmbpaInstTaskDao.queryBpmHisAllOwnerByPage(bpaInstTaskVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpaInstTasks.size());
            this.pageSet(bpaInstTasks, bpaInstTaskVo);
            list = (List)this.beansCopy(bpaInstTasks, BpaInstTaskVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

