/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.console.service.impl;

import com.irdstudio.bfp.console.dao.BpmLinkedInfoDao;
import com.irdstudio.bfp.console.dao.BpmNodeInfoDao;
import com.irdstudio.bfp.console.dao.PluginApproveConfDao;
import com.irdstudio.bfp.console.dao.PluginAssignConfDao;
import com.irdstudio.bfp.console.dao.PluginContentionConfDao;
import com.irdstudio.bfp.console.dao.PluginCountersignConfDao;
import com.irdstudio.bfp.console.dao.domain.BpmLinkedInfo;
import com.irdstudio.bfp.console.dao.domain.BpmNodeInfo;
import com.irdstudio.bfp.console.dao.domain.PluginApproveConf;
import com.irdstudio.bfp.console.dao.domain.PluginAssignConf;
import com.irdstudio.bfp.console.dao.domain.PluginContentionConf;
import com.irdstudio.bfp.console.dao.domain.PluginCountersignConf;
import com.irdstudio.bfp.console.service.facade.BpmNodeInfoService;
import com.irdstudio.bfp.console.service.vo.BpmLinkedInfoVO;
import com.irdstudio.bfp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import com.irdstudio.sdk.beans.core.util.KeyUtil;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmNodeInfoServiceImpl")
public class BpmNodeInfoServiceImpl
implements BpmNodeInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BpmNodeInfoServiceImpl.class);
    @Autowired
    private BpmNodeInfoDao bpmNodeInfoDao;
    @Autowired
    private PluginApproveConfDao pluginApproveConfDao;
    @Autowired
    private PluginCountersignConfDao pluginCountersignConfDao;
    @Autowired
    private PluginAssignConfDao pluginAssignConfDao;
    @Autowired
    private PluginContentionConfDao pluginContentionConfDao;
    @Autowired
    private BpmLinkedInfoDao bpmLinkedInfoDao;

    @Override
    public int insertBpmNodeInfo(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        try {
            BpmNodeInfoService.BpmNodeTypeEnum type;
            BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
            num = this.bpmNodeInfoDao.insertBpmNodeInfo(bpmNodeInfo);
            if (num == 1 && (type = BpmNodeInfoService.BpmNodeTypeEnum.get(inBpmNodeInfoVo.getBpmNodeType())) != null) {
                switch (type) {
                    case PluginApproveConf: {
                        PluginApproveConf pluginApproveConf = new PluginApproveConf();
                        pluginApproveConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginApproveConfDao.insertPluginApproveConf(pluginApproveConf);
                        break;
                    }
                    case PluginCountersignConf: {
                        PluginCountersignConf pluginCountersignConf = new PluginCountersignConf();
                        pluginCountersignConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginCountersignConfDao.insertPluginCountersignConf(pluginCountersignConf);
                        break;
                    }
                    case PluginContentionConf: {
                        PluginContentionConf pluginContentionConf = new PluginContentionConf();
                        pluginContentionConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginContentionConfDao.insertPluginContentionConf(pluginContentionConf);
                        break;
                    }
                    case PluginAssignConf: {
                        PluginAssignConf pluginAssignConf = new PluginAssignConf();
                        pluginAssignConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginAssignConfDao.insertPluginAssignConf(pluginAssignConf);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int insertBpmNodeInfo2(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        BpmNodeInfo newNode = null;
        try {
            newNode = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)newNode);
            BpmNodeInfoVO queryeEndNodeInfoVo = new BpmNodeInfoVO();
            queryeEndNodeInfoVo.setBpmId(newNode.getBpmId());
            queryeEndNodeInfoVo.setBpmNodeType("N99");
            queryeEndNodeInfoVo.setBpmNodeName("\u7ed3\u675f\u8282\u70b9");
            List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllOwnerByPage(queryeEndNodeInfoVo);
            BpmNodeInfo endNode = bpmNodeInfos.get(0);
            BpmLinkedInfoVO bpmLinkedInfoVO = new BpmLinkedInfoVO();
            bpmLinkedInfoVO.setTargetNodeId(endNode.getBpmNodeId());
            List<BpmLinkedInfo> bpmLinkedInfos = this.bpmLinkedInfoDao.queryAllOwnerByPage(bpmLinkedInfoVO);
            BpmLinkedInfo bpmLinkedInfo = bpmLinkedInfos.get(0);
            BpmNodeInfo sourceNode = new BpmNodeInfo();
            sourceNode.setBpmId(bpmLinkedInfo.getSourceNodeId());
            sourceNode = this.bpmNodeInfoDao.queryByPk(sourceNode);
            newNode.setBpmNodeCode(sourceNode.getBpmNodeCode());
            newNode.setBpmNodeType(sourceNode.getBpmNodeType());
            newNode.setBpmNodeName(sourceNode.getBpmNodeName());
            newNode.setX(sourceNode.getX());
            newNode.setY(sourceNode.getY());
            newNode.setH(sourceNode.getH());
            newNode.setW(sourceNode.getW());
            num = this.bpmNodeInfoDao.insertBpmNodeInfo(newNode);
            if (num == 1) {
                bpmLinkedInfo.setTargetNodeId(newNode.getBpmNodeId());
                bpmLinkedInfo.setX1(sourceNode.getX() + 100);
                bpmLinkedInfo.setY1(sourceNode.getY() + 28);
                bpmLinkedInfo.setX2(newNode.getX());
                bpmLinkedInfo.setY2(newNode.getH() + 7);
                this.bpmLinkedInfoDao.updateByPk(bpmLinkedInfo);
                bpmLinkedInfo.setLinkedId(KeyUtil.createUUIDKey());
                bpmLinkedInfo.setSourceNodeId(newNode.getBpmNodeId());
                bpmLinkedInfo.setTargetNodeId(endNode.getBpmNodeId());
                bpmLinkedInfo.setX1(newNode.getX() + 100);
                bpmLinkedInfo.setY1(newNode.getY() + 35);
                bpmLinkedInfo.setX2(endNode.getX() + 100);
                bpmLinkedInfo.setY2(endNode.getY());
                bpmLinkedInfo.setLinkedDesc("start-->git");
                this.bpmLinkedInfoDao.insertBpmLinkedInfo(bpmLinkedInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return num;
    }

    @Override
    public int deleteByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpmNodeInfoVo));
        int num = 0;
        try {
            BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
            num = this.bpmNodeInfoDao.deleteByPk(bpmNodeInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmNodeInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        try {
            BpmNodeInfoVO checkExistsObj = this.queryByPk(inBpmNodeInfoVo);
            if (checkExistsObj == null) {
                num = this.insertBpmNodeInfo(inBpmNodeInfoVo);
            } else {
                BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
                this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
                num = this.bpmNodeInfoDao.updateByPk(bpmNodeInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmNodeInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public BpmNodeInfoVO queryByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBpmNodeInfoVo));
        try {
            BpmNodeInfo queryBpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)queryBpmNodeInfo);
            BpmNodeInfo queryRslBpmNodeInfo = this.bpmNodeInfoDao.queryByPk(queryBpmNodeInfo);
            if (Objects.nonNull((Object)queryRslBpmNodeInfo)) {
                BpmNodeInfoVO outBpmNodeInfoVo = (BpmNodeInfoVO)((Object)this.beanCopy((Object)queryRslBpmNodeInfo, (Object)new BpmNodeInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBpmNodeInfoVo.toString());
                return outBpmNodeInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllOwner(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllOwnerByPage(bpmNodeInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllCurrOrg(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllCurrOrgByPage(bpmNodeInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
        List list = null;
        try {
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllCurrDownOrg(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllCurrDownOrgByPage(bpmNodeInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
        List list = null;
        try {
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public int deleteNodeParam(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        try {
            BpmNodeInfoVO checkExistsObj = this.queryByPk(inBpmNodeInfoVo);
            if (checkExistsObj == null) {
                num = this.insertBpmNodeInfo(inBpmNodeInfoVo);
            } else {
                BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
                this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
                num = this.bpmNodeInfoDao.deleteNodeParam(bpmNodeInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmNodeInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }
}

