/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.rest.engine;

import com.alibaba.dubbo.rpc.service.GenericService;
import com.irdstudio.bfp.executor.core.dao.SSrvsCronConfDao;
import com.irdstudio.bfp.executor.core.dao.SSrvsCronHisDao;
import com.irdstudio.bfp.executor.core.dao.domain.SSrvsCronConf;
import com.irdstudio.bfp.executor.core.dao.domain.SSrvsCronHis;
import com.irdstudio.bfp.executor.core.job.ScheduleJob;
import com.irdstudio.bfp.executor.core.plugin.dubbo.DubboClient;
import com.irdstudio.bfp.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.bfp.executor.rest.init.ExecutorInstInfo;
import com.irdstudio.bfp.executor.rest.schedule.QuartzManager;
import com.irdstudio.bfp.executor.rest.schedule.ScheduleJobUtil;
import com.irdstudio.sdk.beans.core.util.TimeUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzJobEngine
implements Job {
    private static Logger logger = Logger.getLogger(QuartzJobEngine.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Connection conn = null;
        String jobCode = jobExecutionContext.getJobDetail().getKey().getName();
        SSrvsCronConfDao sSrvsCronConfDao = null;
        SSrvsCronConf sSrvsCronConf = null;
        SSrvsCronHisDao sSrvsCronHisDao = null;
        SSrvsCronHis sSrvsCronHis = null;
        long startMills = System.currentTimeMillis();
        try {
            conn = TConnPool.getDefaultPool().getConnection();
            sSrvsCronConfDao = new SSrvsCronConfDao(conn);
            SSrvsCronConf cronConf = new SSrvsCronConf();
            cronConf.setJobCode(jobCode);
            sSrvsCronConfDao.queryByPK(cronConf);
            sSrvsCronConf = sSrvsCronConfDao.queryByPK(cronConf);
            if (sSrvsCronConf == null) {
                logger.info((Object)(jobCode + "\u5c1a\u672a\u521d\u59cb\u5316!"));
                return;
            }
            if (!ExecutorInstInfo.EXECUTOR_ID.equals(sSrvsCronConf.getAgentId())) {
                StringBuffer sb = new StringBuffer(sSrvsCronConf.getJobDesc());
                sb.append("(").append(jobCode).append(")\u53ea\u80fd\u7531").append(sSrvsCronConf.getAgentId()).append("\u8fd0\u884c!!!");
                logger.error((Object)sb);
                return;
            }
            if ("R".equals(sSrvsCronConf.getJobState())) {
                StringBuffer sb = new StringBuffer(sSrvsCronConf.getJobDesc());
                sb.append("(").append(jobCode).append(")\u6b63\u5728").append(sSrvsCronConf.getAgentId()).append("\u8fd0\u884c!");
                logger.info((Object)sb);
                return;
            }
            if ("F".equals(sSrvsCronConf.getJobState())) {
                QuartzManager.removeJob(jobCode, ScheduleJobUtil.JOB_GROUP_NAME, ScheduleJobUtil.TRIGGER_NAME + "-" + sSrvsCronConf.getJobCode(), ScheduleJobUtil.TRIGGER_GROUP_NAME);
                StringBuffer sb = new StringBuffer(sSrvsCronConf.getJobDesc());
                sb.append("(").append(jobCode).append(")\u5728").append(sSrvsCronConf.getAgentId()).append("\u88ab\u7981\u7528,\u5df2\u79fb\u51fa!");
                logger.info((Object)sb);
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            CronExpression cronExpression = new CronExpression(sSrvsCronConf.getCronExpression());
            logger.info((Object)new StringBuffer("\u5f00\u59cb\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]..."));
            sSrvsCronConf.setLastExecuteTime(sdf.format(jobExecutionContext.getFireTime()));
            sSrvsCronConf.setNextExecuteTime(sdf.format(cronExpression.getNextValidTimeAfter(new Date())));
            sSrvsCronConf.setJobState("R");
            sSrvsCronConfDao.updateByPk(sSrvsCronConf);
            sSrvsCronHisDao = new SSrvsCronHisDao(conn);
            sSrvsCronHis = new SSrvsCronHis();
            sSrvsCronHis.setRecordId(this.createUUIDKey());
            sSrvsCronHis.setJobCode(jobCode);
            sSrvsCronHis.setJobDesc(sSrvsCronConf.getJobDesc());
            sSrvsCronHis.setStartTime(TimeUtil.getCurrentDateTime());
            sSrvsCronHis.setAgentId(sSrvsCronConf.getAgentId());
            logger.info((Object)("\u6267\u884c\u4f5c\u4e1a\u7c7b:" + sSrvsCronConf.getJobClass() + ",\u65b9\u6cd5:" + sSrvsCronConf.getJobMethod()));
            if ("hsf".equals(sSrvsCronConf.getJobClassType())) {
                logger.info((Object)"HSF\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb......");
            } else if ("dubbo".equals(sSrvsCronConf.getJobClassType())) {
                logger.info((Object)"DUBBO\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb......");
                GenericService svc = null;
                svc = sSrvsCronConf.getServiceTimeout() == null ? DubboClient.getDubboClient().buildGenericService(sSrvsCronConf.getJobClass(), sSrvsCronConf.getServiceGroup(), sSrvsCronConf.getServiceVersion()) : DubboClient.getDubboClient().buildGenericService(sSrvsCronConf.getJobClass(), sSrvsCronConf.getServiceTimeout().intValue(), sSrvsCronConf.getServiceGroup(), sSrvsCronConf.getServiceVersion());
                String[] paramTypeArr = null;
                Object[] paramValueArr = null;
                logger.info((Object)("interface: " + sSrvsCronConf.getJobClass() + ",version: " + sSrvsCronConf.getServiceVersion() + ", group: " + sSrvsCronConf.getServiceGroup() + ",timeout: " + sSrvsCronConf.getServiceTimeout() + ", param type: " + paramTypeArr + ", param value: " + paramValueArr));
                Object ivkResult = svc.$invoke(sSrvsCronConf.getJobMethod(), paramTypeArr, paramValueArr);
                logger.info((Object)("service call ivkResult: " + ivkResult));
                logger.info((Object)"DUBBO\u670d\u52a1\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f");
            } else {
                logger.info((Object)("\u672c\u5730\u65b9\u6cd5" + sSrvsCronConf.getJobClass() + "\u8c03\u7528\u5f00\u59cb......"));
                Object job = Class.forName(sSrvsCronConf.getJobClass()).newInstance();
                if (ScheduleJob.class.isInstance(job)) {
                    ((ScheduleJob)job).doExcetue(conn, sSrvsCronConf);
                    logger.info((Object)"ScheduleJob -- \u672c\u5730\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f\uff01");
                } else {
                    Method method = job.getClass().getMethod(sSrvsCronConf.getJobMethod(), new Class[0]);
                    method.invoke(job, null);
                    logger.info((Object)"\u672c\u5730\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f\uff01");
                }
            }
            sSrvsCronHis.setResultDesc("successful");
            sSrvsCronHis.setState("Y");
            this.updateStateToEnd(sSrvsCronConfDao, sSrvsCronConf, sSrvsCronHisDao, sSrvsCronHis, startMills);
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u5b8c\u6210..."));
        }
        catch (SQLException e) {
            logger.error((Object)e);
            sSrvsCronHis.setResultDesc(e.getMessage());
            sSrvsCronHis.setState("N");
            try {
                this.updateStateToEnd(sSrvsCronConfDao, sSrvsCronConf, sSrvsCronHisDao, sSrvsCronHis, startMills);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u53d1\u751f\u9519\u8bef..."));
        }
        catch (Exception e) {
            logger.error((Object)e);
            sSrvsCronHis.setResultDesc(e.getMessage());
            sSrvsCronHis.setState("N");
            try {
                this.updateStateToEnd(sSrvsCronConfDao, sSrvsCronConf, sSrvsCronHisDao, sSrvsCronHis, startMills);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            logger.info((Object)new StringBuffer("\u6267\u884c\u4f5c\u4e1a[").append(jobCode).append("]\u53d1\u751f\u9519\u8bef..."));
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
        }
    }

    private void updateStateToEnd(SSrvsCronConfDao sSrvsCronConfDao, SSrvsCronConf sSrvsCronConf, SSrvsCronHisDao sSrvsCronHisDao, SSrvsCronHis sSrvsCronHis, long startMills) throws SQLException {
        long endMills = System.currentTimeMillis();
        BigDecimal costTime = new BigDecimal(endMills - startMills).divide(BigDecimal.valueOf(1000.0));
        sSrvsCronConf.setJobState("A");
        sSrvsCronConf.setCostTime(costTime);
        sSrvsCronConfDao.updateByPk(sSrvsCronConf);
        sSrvsCronHis.setEndTime(TimeUtil.getCurrentDateTime());
        sSrvsCronHis.setCostTime(costTime);
        sSrvsCronHisDao.insertSSrvsCronHis(sSrvsCronHis);
    }

    private String createUUIDKey() {
        return UUID.randomUUID().toString().toUpperCase().replaceAll("-", "");
    }
}

