/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bfp.executor.core.dao;

import com.irdstudio.bfp.executor.core.dao.domain.BpaInstTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class BpaInstTaskDao {
    Connection conn = null;

    public BpaInstTaskDao(Connection conn) {
        this.conn = conn;
    }

    public int insertBpaInstTask(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into bpa_inst_task ( task_id,bpa_serial_no,bpa_id,bpa_order,task_name,stage_id,task_run_state,task_intervene_state,cost_time,start_time,end_time,warn_count,other,state_desc,stage_name,bpa_date,plugin_param) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setObject(1, bpaInstTask.getTaskId());
            ps.setObject(2, bpaInstTask.getBpaSerialNo());
            ps.setObject(3, bpaInstTask.getBpaId());
            ps.setObject(4, bpaInstTask.getBpaOrder());
            ps.setObject(5, bpaInstTask.getTaskName());
            ps.setObject(6, bpaInstTask.getStageId());
            ps.setObject(7, bpaInstTask.getTaskRunState());
            ps.setObject(8, bpaInstTask.getTaskInterveneState());
            ps.setObject(9, bpaInstTask.getCostTime());
            ps.setObject(10, bpaInstTask.getStartTime());
            ps.setObject(11, bpaInstTask.getEndTime());
            ps.setObject(12, bpaInstTask.getWarnCount());
            ps.setObject(13, bpaInstTask.getOther());
            ps.setObject(14, bpaInstTask.getStateDesc());
            ps.setObject(15, bpaInstTask.getStageName());
            ps.setObject(16, bpaInstTask.getBpaDate());
            ps.setObject(17, bpaInstTask.getPluginParam());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert BpaInstTask is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int insertInstByInfo(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("insert into bpa_inst_task (bpa_serial_no, task_id, task_name, bpa_id, bpa_date, stage_id, stage_name, task_run_state, task_intervene_state, plugin_param) select ? as bpa_serial_no, a.task_id, a.task_name, b.bpa_id, ? as bpa_date, a.stage_id, b.stage_name, ? as task_run_state, ? as task_intervene_state, a.plugin_param as plugin_param from bpa_task_info a, bpa_stage_info b where a.bpa_id = ? and a.task_use_state = '0' and (a.task_use_area = '1' or a.task_use_area = '2') and a.bpa_id = b.bpa_id  and a.stage_id = b.stage_id");
            ps.setObject(1, bpaInstTask.getBpaSerialNo());
            ps.setObject(2, bpaInstTask.getBpaDate());
            ps.setObject(3, bpaInstTask.getTaskRunState());
            ps.setObject(4, bpaInstTask.getTaskInterveneState());
            ps.setObject(5, bpaInstTask.getBpaId());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("insert BpaInstTask is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteByPk(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("delete from bpa_inst_task where 1=1 AND task_id = ?  AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstTask.getTaskId());
            ps.setObject(2, bpaInstTask.getBpaSerialNo());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("delete BpaInstTask is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int updateByPk(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("update bpa_inst_task set  task_id = ? , bpa_serial_no = ? , bpa_id = ? , bpa_order = ? , task_name = ? , stage_id = ? , task_run_state = ? , task_intervene_state = ? , cost_time = ? , start_time = ? , end_time = ? , warn_count = ? , other = ? , state_desc = ? , stage_name = ? , bpa_date = ? , plugin_param = ?  where 1=1 AND task_id = ?  AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstTask.getTaskId());
            ps.setObject(2, bpaInstTask.getBpaSerialNo());
            ps.setObject(3, bpaInstTask.getBpaId());
            ps.setObject(4, bpaInstTask.getBpaOrder());
            ps.setObject(5, bpaInstTask.getTaskName());
            ps.setObject(6, bpaInstTask.getStageId());
            ps.setObject(7, bpaInstTask.getTaskRunState());
            ps.setObject(8, bpaInstTask.getTaskInterveneState());
            ps.setObject(9, bpaInstTask.getCostTime());
            ps.setObject(10, bpaInstTask.getStartTime());
            ps.setObject(11, bpaInstTask.getEndTime());
            ps.setObject(12, bpaInstTask.getWarnCount());
            ps.setObject(13, bpaInstTask.getOther());
            ps.setObject(14, bpaInstTask.getStateDesc());
            ps.setObject(15, bpaInstTask.getStageName());
            ps.setObject(16, bpaInstTask.getBpaDate());
            ps.setObject(17, bpaInstTask.getPluginParam());
            ps.setObject(18, bpaInstTask.getTaskId());
            ps.setObject(19, bpaInstTask.getBpaSerialNo());
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("update BpaInstTask is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public BpaInstTask queryByPk(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        BpaInstTask result = null;
        try {
            ps = this.conn.prepareStatement("select task_id,bpa_serial_no,bpa_id,bpa_order,task_name,stage_id,task_run_state,task_intervene_state,cost_time,start_time,end_time,warn_count,other,state_desc,stage_name,bpa_date,plugin_param from bpa_inst_task where 1=1  AND task_id = ?  AND bpa_serial_no = ? ");
            ps.setObject(1, bpaInstTask.getTaskId());
            ps.setObject(2, bpaInstTask.getBpaSerialNo());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new BpaInstTask();
                result.setTaskId(rs.getString("task_id"));
                result.setBpaSerialNo(rs.getString("bpa_serial_no"));
                result.setBpaId(rs.getString("bpa_id"));
                result.setTaskName(rs.getString("task_name"));
                result.setStageId(rs.getString("stage_id"));
                result.setTaskRunState(rs.getString("task_run_state"));
                result.setTaskInterveneState(rs.getString("task_intervene_state"));
                result.setCostTime(rs.getBigDecimal("cost_time"));
                result.setStartTime(rs.getString("start_time"));
                result.setEndTime(rs.getString("end_time"));
                result.setOther(rs.getString("other"));
                result.setStateDesc(rs.getString("state_desc"));
                result.setStageName(rs.getString("stage_name"));
                result.setBpaDate(rs.getString("bpa_date"));
                result.setPluginParam(rs.getString("plugin_param"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("update BpaInstTask is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public List<BpaInstTask> queryAll(BpaInstTask bpaInstTask) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<BpaInstTask> result = new ArrayList<BpaInstTask>();
        try {
            String sql = "select task_id,bpa_serial_no,bpa_id,bpa_order,task_name,stage_id,task_run_state,task_intervene_state,cost_time,start_time,end_time,warn_count,other,state_desc,stage_name,bpa_date,plugin_param from bpa_inst_task where 1=1 ";
            if (bpaInstTask.getTaskId() != null) {
                sql = sql + " AND task_id =  '" + bpaInstTask.getTaskId() + "'";
            }
            if (bpaInstTask.getBpaSerialNo() != null) {
                sql = sql + " AND bpa_serial_no =  '" + bpaInstTask.getBpaSerialNo() + "'";
            }
            if (bpaInstTask.getBpaId() != null) {
                sql = sql + " AND bpa_id =  '" + bpaInstTask.getBpaId() + "'";
            }
            if (bpaInstTask.getBpaOrder() != null) {
                sql = sql + " AND bpa_order =  '" + bpaInstTask.getBpaOrder() + "'";
            }
            if (bpaInstTask.getTaskName() != null) {
                sql = sql + " AND task_name =  '" + bpaInstTask.getTaskName() + "'";
            }
            if (bpaInstTask.getStageId() != null) {
                sql = sql + " AND stage_id =  '" + bpaInstTask.getStageId() + "'";
            }
            if (bpaInstTask.getTaskRunState() != null) {
                sql = sql + " AND task_run_state =  '" + bpaInstTask.getTaskRunState() + "'";
            }
            if (bpaInstTask.getTaskInterveneState() != null) {
                sql = sql + " AND task_intervene_state =  '" + bpaInstTask.getTaskInterveneState() + "'";
            }
            if (bpaInstTask.getCostTime() != null) {
                sql = sql + " AND cost_time =  '" + bpaInstTask.getCostTime() + "'";
            }
            if (bpaInstTask.getStartTime() != null) {
                sql = sql + " AND start_time =  '" + bpaInstTask.getStartTime() + "'";
            }
            if (bpaInstTask.getEndTime() != null) {
                sql = sql + " AND end_time =  '" + bpaInstTask.getEndTime() + "'";
            }
            if (bpaInstTask.getWarnCount() != null) {
                sql = sql + " AND warn_count =  '" + bpaInstTask.getWarnCount() + "'";
            }
            if (bpaInstTask.getOther() != null) {
                sql = sql + " AND other =  '" + bpaInstTask.getOther() + "'";
            }
            if (bpaInstTask.getStateDesc() != null) {
                sql = sql + " AND state_desc =  '" + bpaInstTask.getStateDesc() + "'";
            }
            if (bpaInstTask.getStageName() != null) {
                sql = sql + " AND stage_name =  '" + bpaInstTask.getStageName() + "'";
            }
            if (bpaInstTask.getBpaDate() != null) {
                sql = sql + " AND bpa_date =  '" + bpaInstTask.getBpaDate() + "'";
            }
            sql = sql + " order by stage_id";
            ps = this.conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                BpaInstTask obj = new BpaInstTask();
                obj.setTaskId(rs.getString("task_id"));
                obj.setBpaSerialNo(rs.getString("bpa_serial_no"));
                obj.setBpaId(rs.getString("bpa_id"));
                obj.setTaskName(rs.getString("task_name"));
                obj.setStageId(rs.getString("stage_id"));
                obj.setTaskRunState(rs.getString("task_run_state"));
                obj.setTaskInterveneState(rs.getString("task_intervene_state"));
                obj.setCostTime(rs.getBigDecimal("cost_time"));
                obj.setStartTime(rs.getString("start_time"));
                obj.setEndTime(rs.getString("end_time"));
                obj.setOther(rs.getString("other"));
                obj.setStateDesc(rs.getString("state_desc"));
                obj.setStageName(rs.getString("stage_name"));
                obj.setBpaDate(rs.getString("bpa_date"));
                obj.setPluginParam(rs.getString("plugin_param"));
                result.add(obj);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("view BpaInstTask is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return result;
    }

    public int recordTransfer() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "INSERT INTO bpa_inst_task_h SELECT * FROM bpa_inst_task WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    public int deleteRecord() throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "DELETE FROM bpa_inst_task WHERE start_time IS NOT NULL AND start_time!='' AND DATE_SUB(CURDATE(), INTERVAL 7 DAY) > start_time";
            ps = this.conn.prepareStatement(sql);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException("Record the transfer is Wrong!" + e.getMessage());
        }
        finally {
            this.close(rs, null, ps);
        }
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

