/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.api.rest;

import com.irdstudio.bsp.console.service.facade.SAgentInfoService;
import com.irdstudio.bsp.console.service.vo.SAgentInfoVO;
import com.irdstudio.sdk.beans.core.vo.ResponseData;
import com.irdstudio.sdk.ssm.util.AgentApiUtil;
import com.irdstudio.sdk.ssm.util.StringUtil;
import com.irdstudio.sdk.ssm.util.TimeUtil;
import com.irdstudio.sdk.ssm.vo.ResponseVO;
import com.irdstudio.sdk.ssm.web.AbstractController;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class SAgentInfoController
extends AbstractController {
    @Autowired
    @Qualifier(value="sAgentInfoService")
    private SAgentInfoService sAgentInfoService;

    @RequestMapping(value={"/s/agent/infos"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<SAgentInfoVO>> querySAgentInfoAll(SAgentInfoVO vo) {
        List<SAgentInfoVO> outputVo = this.sAgentInfoService.queryAllOwner(vo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/agent/info/{agentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<SAgentInfoVO> queryByPk(@PathVariable(value="agentId") String agentId) {
        SAgentInfoVO inVo = new SAgentInfoVO();
        inVo.setAgentId(agentId);
        SAgentInfoVO outputVo = this.sAgentInfoService.queryByPk(inVo);
        return this.getResponseData((Object)outputVo);
    }

    @RequestMapping(value={"/s/agent/info"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseData<Integer> deleteByPk(@RequestBody SAgentInfoVO inSAgentInfoVo) {
        int outputVo = this.sAgentInfoService.deleteByPk(inSAgentInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/agent/info"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseData<Integer> updateByPk(@RequestBody SAgentInfoVO inSAgentInfoVo) {
        int outputVo = this.sAgentInfoService.updateByPk(inSAgentInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/agent/info"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Integer> insertSAgentInfo(@RequestBody SAgentInfoVO inSAgentInfoVo) {
        int outputVo = this.sAgentInfoService.insertSAgentInfo(inSAgentInfoVo);
        return this.getResponseData(outputVo);
    }

    @RequestMapping(value={"/s/srvs/cron/active/{agentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> activeSSrvsCronConf(@PathVariable(value="agentId") String agentId) {
        ResponseData data;
        block8: {
            SAgentInfoVO inVo = new SAgentInfoVO();
            inVo.setAgentId(agentId);
            SAgentInfoVO outputVo = this.sAgentInfoService.queryByPk(inVo);
            String AGENT_STATE_START = "R";
            data = null;
            if (outputVo != null && StringUtil.isNotEmpty((String)outputVo.getAgentUrl())) {
                try {
                    ResponseVO response = AgentApiUtil.activeAgent((String)outputVo.getAgentUrl(), (String)agentId);
                    if (response != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(true);
                        if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            inVo.setStartTime(TimeUtil.getCurrentDateTime());
                            inVo.setAgentState(AGENT_STATE_START);
                            this.sAgentInfoService.updateByPk(inVo);
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u6fc0\u6d3b\u6210\u529f\uff01");
                            inVo.setStartTime(TimeUtil.getCurrentDateTime());
                            inVo.setAgentState(AGENT_STATE_START);
                            this.sAgentInfoService.updateByPk(inVo);
                            logger.info("\u6fc0\u6d3b\u6210\u529f\uff01agentId:" + agentId + ", agent\u5730\u5740\uff1a" + outputVo.getAgentUrl());
                        }
                        break block8;
                    }
                    data = this.getResponseData(false);
                    if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block8;
                    }
                    data.setMessage("\u6fc0\u6d3b\u6210\u529f\uff01");
                    logger.info("\u6fc0\u6d3b\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    logger.error("\u6fc0\u6d3b\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + outputVo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(false);
                    data.setMessage("\u6fc0\u6d3b\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + outputVo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f");
                data = this.getResponseData(false);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            }
        }
        return data;
    }

    @RequestMapping(value={"/s/srvs/cron/stop/{agentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Boolean> stopSSrvsCronConf(@PathVariable(value="agentId") String agentId) {
        ResponseData data;
        block8: {
            SAgentInfoVO inVo = new SAgentInfoVO();
            inVo.setAgentId(agentId);
            SAgentInfoVO outputVo = this.sAgentInfoService.queryByPk(inVo);
            String AGENT_STATE_STOP = "S";
            data = null;
            if (outputVo != null && StringUtil.isNotEmpty((String)outputVo.getAgentUrl())) {
                try {
                    ResponseVO response = AgentApiUtil.stopAgent((String)outputVo.getAgentUrl(), (String)agentId);
                    if (response != null && StringUtil.isNotEmpty((String)response.getFlag()) && "success".equals(response.getFlag())) {
                        data = this.getResponseData(true);
                        if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                            data.setMessage(response.getMsg());
                            inVo.setStopTime(TimeUtil.getCurrentDateTime());
                            inVo.setAgentState(AGENT_STATE_STOP);
                            this.sAgentInfoService.updateByPk(inVo);
                            logger.info(response.getMsg());
                        } else {
                            data.setMessage("\u505c\u6b62\u6210\u529f\uff01");
                            inVo.setStopTime(TimeUtil.getCurrentDateTime());
                            inVo.setAgentState(AGENT_STATE_STOP);
                            this.sAgentInfoService.updateByPk(inVo);
                            logger.info("\u505c\u6b62\u6210\u529f\uff01agentId:" + agentId + ", agent\u5730\u5740\uff1a" + outputVo.getAgentUrl());
                        }
                        break block8;
                    }
                    data = this.getResponseData(false);
                    if (response != null && StringUtil.isNotEmpty((String)response.getMsg())) {
                        data.setMessage(response.getMsg());
                        logger.info(response.getMsg());
                        break block8;
                    }
                    data.setMessage("\u505c\u6b62\u5931\u8d25\uff01");
                    logger.info("\u505c\u6b62\u5931\u8d25\uff01");
                }
                catch (Exception e) {
                    logger.error("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + outputVo.getAgentUrl(), (Throwable)e);
                    data = this.getResponseData(false);
                    data.setMessage("\u65e0\u6cd5\u8c03\u7528\u8fdc\u7a0b\u5730\u5740\uff1a" + outputVo.getAgentUrl());
                }
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f");
                data = this.getResponseData(false);
                data.setMessage("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            }
        }
        return data;
    }
}

