/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.console.service.impl;

import com.irdstudio.bsp.console.dao.BpmNodeInfoDao;
import com.irdstudio.bsp.console.dao.PluginApproveConfDao;
import com.irdstudio.bsp.console.dao.PluginAssignConfDao;
import com.irdstudio.bsp.console.dao.PluginContentionConfDao;
import com.irdstudio.bsp.console.dao.PluginCountersignConfDao;
import com.irdstudio.bsp.console.dao.domain.BpmNodeInfo;
import com.irdstudio.bsp.console.dao.domain.PluginApproveConf;
import com.irdstudio.bsp.console.dao.domain.PluginAssignConf;
import com.irdstudio.bsp.console.dao.domain.PluginContentionConf;
import com.irdstudio.bsp.console.dao.domain.PluginCountersignConf;
import com.irdstudio.bsp.console.service.facade.BpmNodeInfoService;
import com.irdstudio.bsp.console.service.vo.BpmNodeInfoVO;
import com.irdstudio.sdk.beans.core.base.FrameworkService;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmNodeInfoServiceImpl")
public class BpmNodeInfoServiceImpl
implements BpmNodeInfoService,
FrameworkService {
    private static Logger logger = LoggerFactory.getLogger(BpmNodeInfoServiceImpl.class);
    @Autowired
    private BpmNodeInfoDao bpmNodeInfoDao;
    @Autowired
    private PluginApproveConfDao pluginApproveConfDao;
    @Autowired
    private PluginCountersignConfDao pluginCountersignConfDao;
    @Autowired
    private PluginAssignConfDao pluginAssignConfDao;
    @Autowired
    private PluginContentionConfDao pluginContentionConfDao;

    @Override
    public int insertBpmNodeInfo(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        try {
            BpmNodeInfoService.BpmNodeTypeEnum type;
            BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
            num = this.bpmNodeInfoDao.insertBpmNodeInfo(bpmNodeInfo);
            if (num == 1 && (type = BpmNodeInfoService.BpmNodeTypeEnum.get(inBpmNodeInfoVo.getBpmNodeType())) != null) {
                switch (type) {
                    case PluginApproveConf: {
                        PluginApproveConf pluginApproveConf = new PluginApproveConf();
                        pluginApproveConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginApproveConfDao.insertPluginApproveConf(pluginApproveConf);
                        break;
                    }
                    case PluginCountersignConf: {
                        PluginCountersignConf pluginCountersignConf = new PluginCountersignConf();
                        pluginCountersignConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginCountersignConfDao.insertPluginCountersignConf(pluginCountersignConf);
                        break;
                    }
                    case PluginContentionConf: {
                        PluginContentionConf pluginContentionConf = new PluginContentionConf();
                        pluginContentionConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginContentionConfDao.insertPluginContentionConf(pluginContentionConf);
                        break;
                    }
                    case PluginAssignConf: {
                        PluginAssignConf pluginAssignConf = new PluginAssignConf();
                        pluginAssignConf.setPluginConfId(inBpmNodeInfoVo.getBpmNodeId());
                        this.pluginAssignConfDao.insertPluginAssignConf(pluginAssignConf);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u5f53\u524d\u65b0\u589e\u6570\u636e\u6761\u6570\u4e3a:" + num);
        return num;
    }

    @Override
    public int deleteByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u5220\u9664\u6570\u636e\u6761\u4ef6\u4e3a:" + (Object)((Object)inBpmNodeInfoVo));
        int num = 0;
        try {
            BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
            num = this.bpmNodeInfoDao.deleteByPk(bpmNodeInfo);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmNodeInfoVo) + "\u5220\u9664\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public int updateByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u4fee\u6539\u6570\u636e\u4e3a:" + inBpmNodeInfoVo.toString());
        int num = 0;
        try {
            BpmNodeInfoVO checkExistsObj = this.queryByPk(inBpmNodeInfoVo);
            if (checkExistsObj == null) {
                num = this.insertBpmNodeInfo(inBpmNodeInfoVo);
            } else {
                BpmNodeInfo bpmNodeInfo = new BpmNodeInfo();
                this.beanCopy((Object)inBpmNodeInfoVo, (Object)bpmNodeInfo);
                num = this.bpmNodeInfoDao.updateByPk(bpmNodeInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
            num = -1;
        }
        logger.debug("\u6839\u636e\u6761\u4ef6:" + (Object)((Object)inBpmNodeInfoVo) + "\u4fee\u6539\u7684\u6570\u636e\u6761\u6570\u4e3a" + num);
        return num;
    }

    @Override
    public BpmNodeInfoVO queryByPk(BpmNodeInfoVO inBpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u53c2\u6570\u4fe1\u606f\u4e3a:" + (Object)((Object)inBpmNodeInfoVo));
        try {
            BpmNodeInfo queryBpmNodeInfo = new BpmNodeInfo();
            this.beanCopy((Object)inBpmNodeInfoVo, (Object)queryBpmNodeInfo);
            BpmNodeInfo queryRslBpmNodeInfo = this.bpmNodeInfoDao.queryByPk(queryBpmNodeInfo);
            if (Objects.nonNull((Object)queryRslBpmNodeInfo)) {
                BpmNodeInfoVO outBpmNodeInfoVo = (BpmNodeInfoVO)((Object)this.beanCopy((Object)queryRslBpmNodeInfo, (Object)new BpmNodeInfoVO()));
                logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a:" + outBpmNodeInfoVo.toString());
                return outBpmNodeInfoVo;
            }
            logger.debug("\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38!", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllOwner(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List list = null;
        try {
            List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllOwnerByPage(bpmNodeInfoVo);
            logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllCurrOrg(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllCurrOrgByPage(bpmNodeInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
        List list = null;
        try {
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<BpmNodeInfoVO> queryAllCurrDownOrg(BpmNodeInfoVO bpmNodeInfoVo) {
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u53c2\u6570\u4fe1\u606f\u4e3a:");
        List<BpmNodeInfo> bpmNodeInfos = this.bpmNodeInfoDao.queryAllCurrDownOrgByPage(bpmNodeInfoVo);
        logger.debug("\u5f53\u524d\u67e5\u8be2\u672c\u4eba\u6240\u5c5e\u673a\u6784\u53ca\u4ee5\u4e0b\u6570\u636e\u4fe1\u606f\u7684\u7ed3\u679c\u96c6\u6570\u91cf\u4e3a:" + bpmNodeInfos.size());
        List list = null;
        try {
            this.pageSet(bpmNodeInfos, bpmNodeInfoVo);
            list = (List)this.beansCopy(bpmNodeInfos, BpmNodeInfoVO.class);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
        }
        return list;
    }
}

