/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.bsp.executor.boot.config;

import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.irdstudio.bsp.executor.rest.init.ActiveConsoleExecutor;
import com.irdstudio.bsp.executor.rest.utils.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.RSAUtility;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnMissingBean(name={"appConfig"})
@Configuration(value="appExecutorConfig")
public class AppConfig {
    @Value(value="${dataSource.url}")
    private String url;
    @Value(value="${dataSource.username.rsa.decrypt}")
    private boolean usernameDecrypt;
    @Value(value="${dataSource.password.rsa.decrypt}")
    private boolean passwordDecrypt;
    @Value(value="${dataSource.username}")
    private String username;
    @Value(value="${dataSource.password}")
    private String password;
    @Value(value="${dataSource.driverClassName}")
    private String driverClassName;
    @Value(value="${dataSource.maxActive:30}")
    private int maxActive;
    @Value(value="${dataSource.initialSize:10}")
    private int initialSize;
    @Value(value="${dataSource.minIdle:10}")
    private int minIdle;
    @Value(value="${dataSource.validationQuery}")
    private String validationQuery;
    @Value(value="${dataSource.testWhileIdle}")
    private boolean testWhileIdle;
    @Value(value="${dataSource.timeBetweenEvictionRunsMillis}")
    private int timeBetweenEvictionRunsMillis;
    @Value(value="${dataSource.minEvictableIdleTimeMillis}")
    private int minEvictableIdleTimeMillis;
    @Value(value="${dataSource.testOnBorrow}")
    private boolean testOnBorrow;
    @Value(value="${dataSource.testOnReturn}")
    private boolean testOnReturn;
    @Value(value="${dataSource.poolPreparedStatements}")
    private boolean poolPreparedStatements;
    @Value(value="${dataSource.maxPoolPreparedStatementPerConnectionSize}")
    private int maxPoolPreparedStatementPerConnectionSize;
    @Value(value="${dataSource.filters}")
    private String filters;
    @Value(value="${dataSource.connectionProperties}")
    private String connectionProperties;
    @Value(value="${dataSource.removeAbandoned}")
    private String removeAbandoned;
    @Value(value="${dataSource.removeAbandonedTimeout}")
    private String removeAbandonedTimeout;
    @Value(value="${dataSource.logAbandoned}")
    private String logAbandoned;
    @Value(value="${e4a.sessionTimeOut:3600000}")
    private int sessionTimeOut;
    @Value(value="${e4a.allowUrl:/**/*}")
    private String allowUrl;

    @Bean
    public DataSource druidDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.url);
        try {
            if (this.usernameDecrypt) {
                String deUsername = RSAUtility.decryptByBase64((String)this.username, (String)PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.privateKey"));
                dataSource.setUsername(deUsername);
            } else {
                dataSource.setUsername(this.username);
            }
            if (this.passwordDecrypt) {
                String dePassword = RSAUtility.decryptByBase64((String)this.password, (String)PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.privateKey"));
                dataSource.setPassword(dePassword);
            } else {
                dataSource.setPassword(this.password);
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(AppConfig.class).error(e.getMessage(), (Throwable)e);
        }
        dataSource.setDriverClassName(this.driverClassName);
        dataSource.setInitialSize(this.initialSize);
        dataSource.setMinIdle(this.minIdle);
        dataSource.setMaxActive(this.maxActive);
        dataSource.setValidationQuery(this.validationQuery);
        dataSource.setTestWhileIdle(this.testWhileIdle);
        dataSource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        dataSource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        dataSource.setTestOnBorrow(this.testOnBorrow);
        dataSource.setTestOnReturn(this.testOnReturn);
        dataSource.setPoolPreparedStatements(this.poolPreparedStatements);
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
        try {
            dataSource.setFilters(this.filters);
        }
        catch (SQLException e) {
            LoggerFactory.getLogger(AppConfig.class).error(e.getMessage(), (Throwable)e);
        }
        Slf4jLogFilter logFilter = new Slf4jLogFilter();
        logFilter.setStatementExecutableSqlLogEnable(false);
        ArrayList<Slf4jLogFilter> filters = new ArrayList<Slf4jLogFilter>(1);
        filters.add(logFilter);
        dataSource.setProxyFilters(filters);
        return dataSource;
    }

    @Autowired
    @Bean
    public SpringContextUtils springContextUtils(ApplicationContext ctx) {
        SpringContextUtils springContextUtils = new SpringContextUtils();
        springContextUtils.setApplicationContext(ctx);
        return springContextUtils;
    }

    @Bean
    public ActiveConsoleExecutor activeConsoleExecutor() {
        ActiveConsoleExecutor activeConsoleExecutor = new ActiveConsoleExecutor();
        return activeConsoleExecutor;
    }
}

