/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.common.rules.apply;

import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.efp.nls.service.common.rules.CheckRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepayMethodAndLoanTermRule
implements CheckRule {
    private static Logger logger = LoggerFactory.getLogger(RepayMethodAndLoanTermRule.class);
    private final String FB01 = "FB01";
    private final String FB03 = "FB03";
    private Map<String, List<String>> rpMdLoanTermMap = new HashMap<String, List<String>>();
    private String rpymtMd;
    private String rpyLoanTerm;

    public RepayMethodAndLoanTermRule(String rpymtMd, String rpyLoanTerm) {
        this.rpMdLoanTermMap.put("FB01", Stream.of("1", "2", "3", "4", "5", "6", "6", "6", "6", "6", "6", "6").collect(Collectors.toList()));
        this.rpMdLoanTermMap.put("FB03", Stream.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12").collect(Collectors.toList()));
        this.rpymtMd = rpymtMd;
        this.rpyLoanTerm = rpyLoanTerm;
    }

    @Override
    public void check() throws BizException {
        if (StringUtils.isEmpty((CharSequence)this.rpymtMd) || StringUtils.isEmpty((CharSequence)this.rpyLoanTerm)) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u8fd8\u6b3e\u65b9\u5f0f\u4e3a\u7a7a\u6216\u8fd8\u6b3e\u5468\u671f\u4e3a\u7a7a\uff0c\u8bf7\u6838\u67e5\uff01");
        }
        List<String> rpyLoanTerms = this.rpMdLoanTermMap.get(this.rpymtMd);
        if (Objects.isNull(rpyLoanTerms)) {
            throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "\u4e0d\u652f\u6301\u8be5\u79cd\u8fd8\u6b3e\u65b9\u5f0f\uff0c\u8bf7\u6838\u67e5\uff01");
        }
        for (String loanTerm : rpyLoanTerms) {
            if (!loanTerm.equals(this.rpyLoanTerm)) continue;
            return;
        }
        throw new BizException(EsbRetCodeStandard.WFJKYWGZ.getValue(), "6\u4e2a\u6708\u4ee5\u5185\u53ef\u9009\u5148\u606f\u540e\u672c(FB01)\u3001\u7b49\u989d\u672c\u606f(FB03)\uff1b6-12\u4e2a\u6708\u7b49\u989d\u672c\u606f(FB03)\uff0c\u8bf7\u6838\u67e5\uff01");
    }
}

