/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.nls.service.yed.common.rules.apply;

import com.irdstudio.basic.framework.core.constant.EsbRetCodeStandard;
import com.irdstudio.basic.framework.core.exception.BizException;
import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.efp.nls.service.yed.common.rules.CheckRule;
import com.irdstudio.efp.nls.service.yed.common.rules.apply.ValidateFormatDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertEndDtRule
implements CheckRule {
    private static Logger logger = LoggerFactory.getLogger(ValidateFormatDate.class);
    private String indivIdExpDt;
    private String applyDate;

    public CertEndDtRule(String indivIdExpDt, String applyDate) {
        this.indivIdExpDt = indivIdExpDt;
        this.applyDate = applyDate;
    }

    @Override
    public void check() throws BizException {
        if (this.indivIdExpDt == null || this.indivIdExpDt.equals("")) {
            logger.error("\u67e5\u8be2\u5230\u7528\u6237\u7684\u8bc1\u4ef6\u5230\u671f\u65e5\u4e3a\u7a7a!");
            throw new BizException(EsbRetCodeStandard.KHXXJYBTG.getValue(), "\u67e5\u8be2\u5230\u7528\u6237\u7684\u8bc1\u4ef6\u5230\u671f\u65e5\u4e3a\u7a7a!");
        }
        String expDt = this.indivIdExpDt;
        if (this.indivIdExpDt.contains("\u957f\u671f")) {
            expDt = "2099-12-31";
        } else if (this.indivIdExpDt.length() > 10) {
            this.indivIdExpDt = this.indivIdExpDt.substring(this.indivIdExpDt.length() - 8, this.indivIdExpDt.length());
            expDt = DateUtility.format8To10((String)this.indivIdExpDt);
        } else if (this.indivIdExpDt.length() == 8) {
            expDt = DateUtility.format8To10((String)this.indivIdExpDt);
        }
        if (DateUtility.compareToDate((String)expDt, (String)this.applyDate) < 0) {
            logger.error("\u7533\u8bf7\u7528\u6237\u8bc1\u4ef6\u5df2\u5230\u671f");
            throw new BizException(EsbRetCodeStandard.KHXXJYBTG.getValue(), "\u7533\u8bf7\u7528\u6237\u8bc1\u4ef6\u5df2\u5230\u671f!");
        }
    }
}

