/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.riskm.common.util;

import com.irdstudio.basic.framework.core.util.DateUtility;
import com.irdstudio.basic.framework.core.util.ReflectUtility;
import com.irdstudio.basic.framework.core.util.StringUtil;
import com.irdstudio.efp.riskm.common.annotation.ExcelField;
import com.irdstudio.efp.riskm.common.annotation.ExcelSheet;
import com.irdstudio.efp.riskm.common.util.FieldReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportUtil.class);

    public static <T> List<T> importExcelByClass(File excelFile, Class<?> sheetClass, String sheetname) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            List<T> dataList = ExcelImportUtil.importExcelByClass(workbook, sheetClass, sheetname);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> importExcelByClass(Workbook workbook, Class<?> sheetClass, String sheetname) throws Exception {
        List<T> sheetDataList = ExcelImportUtil.importSheetByClass(workbook, sheetClass, sheetname);
        return sheetDataList;
    }

    public static <T> List<T> importSheetByClass(Workbook workbook, Class<?> sheetClass, String sheetname) throws Exception {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && excelSheet.name().trim().length() > 0 ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
                for (Field field : sheetClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    fields.add(field);
                }
            }
            if (fields.isEmpty()) {
                throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new Exception("\u8bf7\u5c06\u5bfc\u5165\u6570\u636e\u7684sheet\u540d\u79f0\u4fee\u6539\u4e3a\u201c" + sheetname + "\u201d\uff01");
            }
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Object rowObj = null;
                    for (int i = 0; i < fields.size(); ++i) {
                        ExcelField excel;
                        Field field;
                        Object fieldValue;
                        Cell cell = rowX.getCell(i);
                        if (cell == null) continue;
                        String fieldValueStr = "";
                        fieldValueStr = ExcelImportUtil.getCellStringVal(cell);
                        if (!StringUtil.isNotEmpty((String)fieldValueStr) || (fieldValue = FieldReflectionUtil.parseValue(field = (Field)fields.get(i), fieldValueStr)) == null) continue;
                        if (rowObj == null) {
                            rowObj = sheetClass.newInstance();
                        }
                        if (StringUtil.isNotEmpty((String)(excel = field.getDeclaredAnnotation(ExcelField.class)).dicType()) && fieldValue.toString().indexOf("-") < 0) {
                            throw new Exception("\u8f93\u5165\u7684\u683c\u5f0f\u5e94\u4e3akey-value!");
                        }
                        if (StringUtil.isNotEmpty((String)excel.dicType()) && fieldValue.toString().indexOf("-") >= 0) {
                            fieldValue = fieldValue.toString().split("-")[0];
                        }
                        ReflectUtility.setObjectFieldValue(rowObj, (Field)field, (Object)fieldValue);
                    }
                    if (rowObj != null) {
                        dataList.add(rowObj);
                    }
                }
                ++rowIndex;
            }
            return dataList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String getCellStringVal(Cell cell) {
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case NUMERIC: {
                String value = "";
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    value = DateUtility.formatDate((Date)date, (String)"yyyy-MM-dd");
                } else {
                    double dValue = cell.getNumericCellValue();
                    value = ExcelImportUtil.getRealStringValueOfDouble(dValue);
                }
                return value;
            }
            case STRING: {
                return cell.getStringCellValue();
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return cell.getCellFormula();
            }
            case BLANK: {
                return "";
            }
            case ERROR: {
                return String.valueOf(cell.getErrorCellValue());
            }
        }
        return "";
    }

    private static String getRealStringValueOfDouble(Double d) {
        String doubleStr = d.toString();
        boolean b = doubleStr.contains("E");
        if (b) {
            BigDecimal bd = new BigDecimal(doubleStr);
            doubleStr = bd.toPlainString();
        } else {
            Pattern p = Pattern.compile(".0$");
            Matcher m = p.matcher(doubleStr);
            if (m.find()) {
                doubleStr = doubleStr.replace(".00", "");
            }
        }
        return doubleStr;
    }
}

