/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.riskm.common.util;

import com.irdstudio.basic.framework.core.util.StringUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.IOException;

public class ItextPdfUtil {
    public static Font setFont(int size, int style) throws DocumentException, IOException {
        BaseFont bf = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        Font font = new Font(bf);
        font.setSize((float)size);
        font.setStyle(style);
        return font;
    }

    public static Font setFont(int size, int style, BaseColor color) throws DocumentException, IOException {
        Font font = ItextPdfUtil.setFont(size, style);
        font.setColor(color);
        return font;
    }

    public static PdfPTable setPdfPTable(int numColumns, float spacingBefore, float spacingAfter, float totalWidth, float minimumHeight) {
        PdfPTable pfPTable = new PdfPTable(numColumns);
        pfPTable.setSpacingBefore(spacingBefore);
        pfPTable.setSpacingAfter(spacingAfter);
        pfPTable.setHorizontalAlignment(1);
        pfPTable.setTotalWidth(totalWidth);
        pfPTable.getDefaultCell().setMinimumHeight(minimumHeight);
        pfPTable.setLockedWidth(true);
        return pfPTable;
    }

    public static PdfPTable setCellContent(PdfPTable pfPTable, Font cellFont, Font tabFont, int cellNum, String[] cellTitile, int[] colSpan, String[] cellContent) throws Exception {
        for (int i = 0; i < cellTitile.length && i < cellContent.length; ++i) {
            PdfPCell cellCell = ItextPdfUtil.setCell(cellFont, cellTitile[i], colSpan[i]);
            PdfPCell tabCell = ItextPdfUtil.setCell(tabFont, cellContent[i], colSpan[i]);
            pfPTable.addCell(cellCell);
            pfPTable.addCell(tabCell);
            if (cellNum % 2 != 1 || i % 2 != 0) continue;
            pfPTable.addCell((Phrase)new Paragraph(" ", tabFont));
        }
        return pfPTable;
    }

    public static PdfPTable setCellContent(PdfPTable pfPTable, Font cellFont, Font tabFont, int cellNum, String[] cellTitile, int[] colCellSpan, int[] colSpan, String[] cellNewCont, String[] cellOldCont) throws Exception {
        for (int i = 0; i < cellTitile.length && i < cellNewCont.length && i < cellOldCont.length; ++i) {
            PdfPCell tabOldCell;
            PdfPCell tabNewCell;
            PdfPCell cellCell;
            Font tabRedFont = ItextPdfUtil.setFont(12, 0, BaseColor.RED);
            if (!StringUtil.isNullorBank((String)cellNewCont[i]) && !cellNewCont[i].equals(cellOldCont[i]) || StringUtil.isNullorBank((String)cellNewCont[i]) && !StringUtil.isNullorBank((String)cellOldCont[i])) {
                cellCell = ItextPdfUtil.setCell(tabRedFont, cellTitile[i], colCellSpan[i]);
                tabNewCell = ItextPdfUtil.setCell(tabRedFont, cellNewCont[i], colSpan[i]);
                tabOldCell = ItextPdfUtil.setCell(tabRedFont, cellOldCont[i], colSpan[i]);
                pfPTable.addCell(cellCell);
                pfPTable.addCell(tabNewCell);
                pfPTable.addCell(tabOldCell);
            } else {
                cellCell = ItextPdfUtil.setCell(cellFont, cellTitile[i], colCellSpan[i]);
                tabNewCell = ItextPdfUtil.setCell(tabFont, cellNewCont[i], colSpan[i]);
                tabOldCell = ItextPdfUtil.setCell(tabFont, cellOldCont[i], colSpan[i]);
                pfPTable.addCell(cellCell);
                pfPTable.addCell(tabNewCell);
                pfPTable.addCell(tabOldCell);
            }
            if (cellNum % 2 != 1 || i % 2 != 0) continue;
            pfPTable.addCell((Phrase)new Paragraph(" ", tabFont));
        }
        return pfPTable;
    }

    public static PdfPCell setCell(Font cellFont, String cellContent, int colSpan) throws Exception {
        PdfPCell cell = new PdfPCell(new Phrase(cellContent, cellFont));
        cell.setColspan(colSpan);
        return cell;
    }
}

