/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.efp.riskm.common.util;

import com.irdstudio.basic.framework.core.util.Base64;
import com.irdstudio.basic.framework.core.util.FileUtil;
import com.irdstudio.efp.riskm.common.util.ItextPdfUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PspCheckRptPdfTemplete {
    private static Logger logger = LoggerFactory.getLogger(PspCheckRptPdfTemplete.class);
    private static String CTRL_SUFFIX = ".pdf";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPdf(String locaFilePath, String bizSerno, String[] basicCont, String[] regCont, String[] pbocOldCont, String[] pbocNewCont, String[] pbocCellTitile) {
        File file = new File(locaFilePath);
        if (!file.exists()) {
            logger.info("\u672c\u5730\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939......");
            file.mkdir();
        }
        String fileStrByte = null;
        String fileName = bizSerno + CTRL_SUFFIX;
        File pdfFile = null;
        String filePath = locaFilePath + fileName;
        Document document = null;
        String title = "\u68c0\u67e5\u62a5\u544a";
        try {
            document = new Document(PageSize.A4, 30.0f, 30.0f, 40.0f, 20.0f);
            pdfFile = new File(filePath);
            if (pdfFile != null && pdfFile.exists() && pdfFile.isFile()) {
                pdfFile.delete();
            }
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(filePath));
            document.open();
            Font titleFont = ItextPdfUtil.setFont(32, 1);
            Font mintTitleFont = ItextPdfUtil.setFont(18, 0);
            Font cellFont = ItextPdfUtil.setFont(16, 0);
            Font tabFont = ItextPdfUtil.setFont(12, 0);
            int basicCellNum = 4;
            PdfPTable basicTable = ItextPdfUtil.setPdfPTable(basicCellNum, 40.0f, 0.0f, 500.0f, 30.0f);
            int regCellNum = 4;
            PdfPTable regTable = ItextPdfUtil.setPdfPTable(regCellNum, 40.0f, 0.0f, 500.0f, 30.0f);
            int pbocCellNum = 6;
            PdfPTable pbocTable = ItextPdfUtil.setPdfPTable(pbocCellNum, 40.0f, 0.0f, 500.0f, 30.0f);
            PdfPCell cell = null;
            document.newPage();
            cell = new PdfPCell(new Phrase("1.\u57fa\u672c\u4fe1\u606f", mintTitleFont));
            cell.setColspan(basicCellNum);
            basicTable.addCell(cell);
            cell = new PdfPCell(new Phrase(" ", mintTitleFont));
            cell.setColspan(basicCellNum);
            basicTable.addCell(cell);
            cell = new PdfPCell(new Phrase("2.\u767b\u8bb0\u4fe1\u606f", mintTitleFont));
            cell.setColspan(regCellNum);
            regTable.addCell(cell);
            cell = new PdfPCell(new Phrase(" ", mintTitleFont));
            cell.setColspan(regCellNum);
            regTable.addCell(cell);
            cell = new PdfPCell(new Phrase("3.\u4eba\u884c\u5f81\u4fe1\u4fe1\u606f", mintTitleFont));
            cell.setColspan(pbocCellNum);
            pbocTable.addCell(cell);
            cell = new PdfPCell(new Phrase(" ", mintTitleFont));
            cell.setColspan(pbocCellNum);
            pbocTable.addCell(cell);
            String[] basicCellTitile = new String[]{"\u68c0\u67e5\u4efb\u52a1\u7f16\u53f7", "\u68c0\u67e5\u540d\u79f0", "\u5ba2\u6237\u7f16\u53f7", "\u5ba2\u6237\u540d\u79f0", "\u8bc1\u4ef6\u7c7b\u578b", "\u8bc1\u4ef6\u53f7\u7801", "\u6388\u4fe1\u603b\u989d(\u5143)", "\u8d37\u6b3e\u603b\u4f59\u989d(\u5143)", "\u5176\u4ed6\u4e0d\u5229\u56e0\u7d20", "\u60c5\u51b5\u8bf4\u660e\u53ca\u5efa\u8bae"};
            int[] basicColSpan = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 2, 2};
            ItextPdfUtil.setCellContent(basicTable, cellFont, tabFont, basicCellNum, basicCellTitile, basicColSpan, basicCont);
            String[] regCellTitile = new String[]{"\u5ba2\u6237\u7ecf\u7406\u53f7", "\u4e3b\u7ba1\u673a\u6784", "\u521b\u5efa\u4eba", "\u521b\u5efa\u65f6\u95f4"};
            int[] regColSpan = new int[]{1, 1, 1, 1};
            ItextPdfUtil.setCellContent(regTable, cellFont, tabFont, regCellNum, regCellTitile, regColSpan, regCont);
            cell = new PdfPCell(new Phrase("\u89c4\u5219\u540d\u79f0", cellFont));
            cell.setColspan(4);
            pbocTable.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5386\u53f2\u503c", cellFont));
            cell.setColspan(1);
            pbocTable.addCell(cell);
            cell = new PdfPCell(new Phrase("\u5f53\u524d\u503c", cellFont));
            cell.setColspan(1);
            pbocTable.addCell(cell);
            int[] pbocColCellSpan = new int[pbocCellTitile.length];
            for (int i = 0; i < pbocCellTitile.length; ++i) {
                pbocColCellSpan[i] = 4;
            }
            int[] pbocColSpan = new int[pbocCellTitile.length];
            for (int i = 0; i < pbocCellTitile.length; ++i) {
                pbocColSpan[i] = 1;
            }
            ItextPdfUtil.setCellContent(pbocTable, tabFont, tabFont, pbocCellNum, pbocCellTitile, pbocColCellSpan, pbocColSpan, pbocOldCont, pbocNewCont);
            document.newPage();
            pdfWriter.setPageEmpty(false);
            Paragraph bgTitle = new Paragraph(title, titleFont);
            bgTitle.setAlignment(1);
            document.add((Element)bgTitle);
            document.add((Element)basicTable);
            document.add((Element)regTable);
            document.newPage();
            document.add((Element)pbocTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (document != null) {
                document.close();
            }
            fileStrByte = PspCheckRptPdfTemplete.fileToStrByte(filePath);
            pdfFile.delete();
        }
        return fileStrByte;
    }

    private static String fileToStrByte(String filePath) {
        File file = new File(filePath);
        String fileStr = null;
        byte[] fileBytes = null;
        try {
            fileBytes = FileUtil.toByteArray((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("\u6587\u4ef6\u8f6c\u5b57\u8282\u6570\u7ec4\u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f" + e.getMessage());
        }
        fileStr = Base64.encodeBytes((byte[])fileBytes);
        return fileStr;
    }
}

