/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.excel;

import com.alibaba.excel.metadata.BaseRowModel;
import com.irdstudio.sdk.beans.excel.ExcelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ExcelReadFactory<T extends BaseRowModel> {
    private String filePath;
    private InputStream inputStream;
    private T template;
    private Integer sheetNo;
    private Integer headLine;

    public ExcelReadFactory(Builder<T> builder) {
        this.filePath = ((Builder)builder).filePath;
        this.inputStream = ((Builder)builder).inputStream;
        this.template = ((Builder)builder).template;
        this.sheetNo = ((Builder)builder).sheetNo;
        this.headLine = ((Builder)builder).headLine;
    }

    public List<T> read() throws IOException {
        if (this.inputStream != null) {
            return ExcelUtil.readExcel(this.inputStream, this.template, this.sheetNo, this.headLine);
        }
        if (this.filePath != null && this.sheetNo != null) {
            return ExcelUtil.readExcel(this.filePath, this.template, this.sheetNo, this.headLine);
        }
        return ExcelUtil.readExcel(this.filePath, this.template, this.headLine);
    }

    public static <T extends BaseRowModel> Builder<T> create(T template) {
        return new Builder<T>().template(template);
    }

    public static class Builder<T extends BaseRowModel> {
        private String filePath;
        private InputStream inputStream;
        private T template;
        private Integer sheetNo;
        private Integer headLine;

        public Builder<T> filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder<T> template(T template) {
            this.template = template;
            return this;
        }

        public Builder<T> inputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder<T> sheetNo(Integer sheetNo) {
            this.sheetNo = sheetNo;
            return this;
        }

        public Builder<T> headLine(Integer headLine) {
            this.headLine = headLine;
            return this;
        }

        public List<T> read() throws IOException {
            return this.build().read();
        }

        public ExcelReadFactory<T> build() {
            return new ExcelReadFactory(this);
        }
    }
}

