/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.irdstudio.sdk.beans.excel.FileUtil;
import com.irdstudio.sdk.beans.excel.ObjectExcelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ExcelUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseRowModel> List<T> readExcel(String filePath, T object, Integer sheetNo, Integer headLine) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = FileUtil.getFileInputStream(filePath);
            List<T> list = ExcelUtil.readExcel(inputStream, object, sheetNo, headLine);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseRowModel> List<T> readExcel(String filePath, T object, Integer headLine) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = FileUtil.getFileInputStream(filePath);
            List<T> list = ExcelUtil.readAll(inputStream, object, headLine);
            return list;
        }
    }

    public static <T extends BaseRowModel> List<T> readAll(InputStream inputStream, T object, Integer headLine) {
        ObjectExcelListener listener = new ObjectExcelListener();
        ExcelReader reader = new ExcelReader(inputStream, null, listener, false);
        List sheets = reader.getSheets();
        for (Sheet sheet : sheets) {
            sheet.setHeadLineMun(headLine.intValue());
            sheet.setClazz(object.getClass());
            reader.read(sheet);
        }
        return listener.getResult();
    }

    public static <T extends BaseRowModel> List<T> readExcel(InputStream inputStream, T object, Integer sheetNo) {
        return ExcelUtil.readExcel(inputStream, object, sheetNo, (Integer)1);
    }

    public static <T extends BaseRowModel> List<T> readExcel(InputStream inputStream, T object, Integer sheetNo, Integer headLine) {
        ObjectExcelListener listener = new ObjectExcelListener();
        ExcelReader reader = new ExcelReader(inputStream, null, listener, false);
        reader.read(new Sheet(sheetNo.intValue(), headLine.intValue(), object.getClass()));
        return listener.getResult();
    }

    public static <T extends BaseRowModel> void writeExcel(OutputStream outputStream, List<T> content) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, 1);
    }

    public static <T extends BaseRowModel> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, sheetNo, 1);
    }

    public static <T extends BaseRowModel> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo, Integer headLine) throws IOException {
        ExcelUtil.writeExcel(outputStream, content, sheetNo, headLine, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseRowModel> void writeExcel(OutputStream outputStream, List<T> content, Integer sheetNo, Integer headLine, String sheetName, boolean finish) throws IOException {
        if (content == null || content.isEmpty()) {
            return;
        }
        ExcelWriter writer = null;
        try {
            Sheet sheet = new Sheet(sheetNo.intValue(), headLine.intValue(), ((BaseRowModel)content.get(0)).getClass(), sheetName, null);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            writer.write(content, sheet);
        }
        finally {
            if (finish && writer != null) {
                writer.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends BaseRowModel> void writeMultipleSheet(OutputStream outputStream, List<String> sheetNames, List<List<T>> contents) throws IOException {
        if (contents == null || contents.isEmpty() || contents.get(0).isEmpty()) {
            return;
        }
        ExcelWriter writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
        Class<?> clazz = ((BaseRowModel)contents.get(0).get(0)).getClass();
        for (int i = 0; i < contents.size(); ++i) {
            List<T> content = contents.get(i);
            String sheetName = sheetNames.get(i);
            boolean finish = i == contents.size() - 1;
            try {
                Sheet sheet = new Sheet(i + 1, 0, clazz, sheetName, null);
                writer.write(content, sheet);
                continue;
            }
            finally {
                if (finish && writer != null) {
                    writer.finish();
                }
            }
        }
    }
}

