/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdk.beans.ssh.utils;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SCPClient;
import ch.ethz.ssh2.SFTPException;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3DirectoryEntry;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RemoteShellClient {
    private static Logger logger = LoggerFactory.getLogger(RemoteShellClient.class);
    private String ip;
    private String user;
    private String passwd;
    private Connection conn;

    public RemoteShellClient(String ip, String user, String passwd) {
        this.ip = ip;
        this.user = user;
        this.passwd = passwd;
    }

    public boolean login() {
        logger.error("\u7528\u6237{}\u5bc6\u7801{}\u767b\u5f55Linux\u670d\u52a1\u5668{}......", new Object[]{this.user, this.passwd, this.ip});
        this.conn = new Connection(this.ip);
        try {
            this.conn.connect();
            return this.conn.authenticateWithPassword(this.user, this.passwd);
        }
        catch (IOException e) {
            logger.error("\u767b\u5f55\u8fdc\u7a0bLinux\u670d\u52a1\u5668\u5931\u8d25\uff01", (Throwable)e);
            return false;
        }
    }

    public void putFile(String fileName, String remotePath) {
        logger.info("\u670d\u52a1\u5668:{},\u4e0a\u4f20\u6587\u4ef6\uff1a{}\u5230{}", new Object[]{this.ip, fileName, remotePath});
        SCPClient sc = new SCPClient(this.conn);
        try {
            sc.put(fileName, remotePath);
        }
        catch (IOException e) {
            logger.error("\u4e0a\u4f20\u672c\u5730\u6587\u4ef6\u5230\u670d\u52a1\u5668\u76ee\u5f55\u4e0b\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public void copyFile(String fileName, String localPath) {
        logger.info("\u670d\u52a1\u5668:{},\u4e0b\u8f7d\u6587\u4ef6\uff1a{}\u5230\u672c\u5730{}", new Object[]{this.ip, fileName, localPath});
        SCPClient sc = new SCPClient(this.conn);
        try {
            sc.get(fileName, localPath);
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u670d\u52a1\u5668\u6587\u4ef6\u5230\u672c\u5730\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public boolean getFileProperties(String remotePath) {
        try {
            SFTPv3Client sft = new SFTPv3Client(this.conn);
            Vector v = sft.ls(remotePath);
            for (int i = 0; i < v.size(); ++i) {
                SFTPv3DirectoryEntry s = new SFTPv3DirectoryEntry();
                s = (SFTPv3DirectoryEntry)v.get(i);
                String fileName = s.filename;
                Long fileSize = s.attributes.size;
                logger.info("\u6587\u4ef6\u540d:{},\u6587\u4ef6\u5927\u5c0f:{}", (Object)fileName, (Object)fileSize);
            }
            sft.close();
        }
        catch (SFTPException e) {
            logger.error("\u5728\u8fdc\u7a0bLINUX\u670d\u52a1\u5668\u4e0a\uff0c\u5728\u6307\u5b9a\u76ee\u5f55\u4e0b\uff0c\u83b7\u53d6\u6587\u4ef6\u5404\u4e2a\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
            if (e.getMessage().contains("No such file")) {
                return false;
            }
        }
        catch (Exception e1) {
            logger.error("\u5728\u8fdc\u7a0bLINUX\u670d\u52a1\u5668\u4e0a\uff0c\u5728\u6307\u5b9a\u76ee\u5f55\u4e0b\uff0c\u83b7\u53d6\u6587\u4ef6\u5404\u4e2a\u5c5e\u6027\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e1);
        }
        return true;
    }

    public void delFile(String remotePath, String fileName) {
        try {
            SFTPv3Client sft = new SFTPv3Client(this.conn);
            Vector v = sft.ls(remotePath);
            for (int i = 0; i < v.size(); ++i) {
                SFTPv3DirectoryEntry s = new SFTPv3DirectoryEntry();
                s = (SFTPv3DirectoryEntry)v.get(i);
                if (s.filename.equals(fileName)) {
                    sft.rm(remotePath + s.filename);
                }
                sft.close();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public int exec(String cmds) {
        Integer ret = null;
        try {
            Session session = this.conn.openSession();
            session.execCommand(cmds);
            logger.info("\u670d\u52a1\u5668:{},\u6267\u884c\u547d\u4ee4\uff1a{}", (Object)this.ip, (Object)cmds);
            this.processStdout(session.getStdout(), "UTF-8");
            session.waitForCondition(32, 3600000L);
            session.close();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u811a\u672c\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return ret == null ? 1 : ret;
    }

    public String execAndGetStdout(String cmds) {
        String stdout = null;
        try {
            Session session = this.conn.openSession();
            logger.info("\u670d\u52a1\u5668:{},\u6267\u884c\u547d\u4ee4\uff1a{}", (Object)this.ip, (Object)cmds);
            session.execCommand(cmds);
            stdout = this.processStdout2(session.getStdout(), "UTF-8");
            session.waitForCondition(32, 3600000L);
            int ret = session.getExitStatus();
            logger.info("\u6307\u4ee4\u6267\u884c\u7ed3\u675f\u540e\u7684\u72b6\u6001\u4e3a\uff1a{}", (Object)ret);
            session.close();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u811a\u672c\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return stdout;
    }

    public void exit() {
        this.conn.close();
    }

    private String processStdout(InputStream in, String charset) {
        StreamGobbler stdout = new StreamGobbler(in);
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout, charset));
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append(line + "\n");
                System.out.println(line);
                logger.info(line);
            }
            br.close();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u6790\u811a\u672c\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790\u811a\u672c\u51fa\u9519\uff01", (Throwable)e);
        }
        return buffer.toString();
    }

    private String processStdout2(InputStream in, String charset) {
        StreamGobbler stdout = new StreamGobbler(in);
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout, charset));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ("".equals(line)) continue;
                buffer.append(line).append("#$#");
            }
            br.close();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u89e3\u6790\u811a\u672c\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790\u811a\u672c\u51fa\u9519\uff01", (Throwable)e);
        }
        return buffer.toString();
    }
}

