(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.DashboardView = {
        props: {
            dashboardData: Array,
            disabled: Boolean,
            windowHeight: [Number, String]
        },
        emits: ['dblclick', 'click'],
        data(){
            return {
            }
        },
        methods: {
            handlerDblClick(row) {
                this.$emit('dblclick', row)
            },
            handlerClick(row) {
                this.$emit('click', row)
            }
        },
        computed:{
            scrollbarHeight() {
                if (this.windowHeight) {
                    return this.windowHeight
                }
                let height = window.innerHeight ;
                return height - 300;
            }
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<el-scrollbar :wrap-style="{ height: scrollbarHeight + 20 }" :style="{ height: scrollbarHeight + 30  }" noresize>
    <div class="dash-view">
        <div v-for="(item, index) in dashboardData" :key="index" class="dash-card">
            <el-card class="box-card" shadow="never" :body-style="{ margin: '0', padding: '0'}" style="margin: 5px 0px;">
                <template #header>
                    <div class="card-header">
                        <span><i class="iconfont icon-move" ></i>{{item.name}}({{ item.count }})</span>
                    </div>
                </template>
                <el-scrollbar :height="scrollbarHeight - 20">
                    <el-empty v-if="item.list.length == 0" description="暂无数据"></el-empty>
                    <el-card v-for="(row, rIdx) in item.list" :key="rIdx" shadow="never" class="dash-item-card" 
                            :body-style="{ background: '#eaecf5' }"
                            @dblclick="handlerDblClick(row)" @click="handlerClick(row)">
                        <slot :row="row" :item="item" :index="index" :rIdx="rIdx"></slot>
                    </el-card>
                </el-scrollbar>
                
            </el-card>
        </div>
    </div>
</el-scrollbar>
        `
    }
}));
