(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ?
        factory(exports, require('vue'), require('jQuery'),
            require('ElementPlus'), require('ElementPlusLocaleZhCn'), require('ElementPlusIconsVue'), require('CardComponents'),
            require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery',
                'ElementPlus', 'ElementPlusLocaleZhCn', 'ElementPlusIconsVue', 'CardComponents',
                'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global, global.Vue, global.$,
                global.ElementPlus, global.ElementPlusLocaleZhCn, global.ElementPlusIconsVue, global.CardComponents,
                global._, global.loadjs));
})(this, (function (exports, vue, $, ElementPlus, ElementPlusLocaleZhCn, ElementPlusIconsVue, CardComponents,  _) {

    var createDialog = function(title, url, options = { width: '70%', top: '10vh', fullscreen: false}) {

        // 不是绝对路径， 处理成当前页面的相对路径 从window.top打开
        if (!options.inner && !(url.startsWith('/') || url.startsWith('http'))) {
            let curPath = window.location.pathname ;
            curPath = curPath.substring(0, curPath.lastIndexOf('/') + 1)
            url = curPath + url
        }

        if (window.top.ElementDialog && window !== window.top) {
            return window.top.ElementDialog.createDialog(title, url, options)
        }

        const dialogId = new Date().getTime();
        if (!window.top._GlobalZIndex) {
            window.top._GlobalZIndex = 1000
        }
        const prefZIndex = window.top._GlobalZIndex++
        const instance = Vue.createApp({

            data(){
                return {
                    visibleDialog: false,
                    windowHeight: 0,
                    loading: false,
                    title: title,
                    url: url,
                    options: options,

                    dialogId: dialogId,

                    resolve: undefined,
                    reject: undefined,
                    zIndex : prefZIndex
                }
            },
            methods: {
                HandleFullscreen() {
                    this.options.fullscreen = !this.options.fullscreen;
                },
                setUrl(pageUrl){
                    this.url = pageUrl
                },
                open(resolve, reject) {
                    const self = this;
                    self.resolve = resolve;
                    self.reject = reject;
                    self.visibleDialog = false;
                    setTimeout(function() {
                        self.visibleDialog = true;
                    }, 50)

                    if (!window.top._elementInstances) {
                        window.top._elementInstances = {}
                    }
                    window.top._elementInstances[self.dialogId] = self;
                },
                close() {
                    const self = this;
                    self.visibleDialog = false;
                    // 销毁弹框 DOM
                    setTimeout(function(){
                        window.top.$('#div' + self.dialogId ).remove();
                        window.top._elementInstances[self.dialogId] = undefined;
                    }, 20)
                },

                getWindowSize: _.debounce(function() {
                    let height = window.top.innerHeight ;
                    this.windowHeight = height - 50;
                }, 150)

            },
            computed:{
                styleObject() {
                    return {
                        bottom: "inherit",
                    }
                },
                breadcrumb() {
                    if (this.title.indexOf('-') >= 0 ) {
                        return this.title.split('-')
                    }
                    return [this.title];
                },
                dialogTitle() {
                    if (this.title.indexOf('-') >= 0 ) {
                        return this.title.split('-').join('->')
                    }
                    return this.title;
                },
                fullScreenIcon() {
                    if (this.options.fullscreen) {
                        return ['icon-suoxiao']
                    } else {
                        return ['icon-fangkuangweixuan']
                    }
                }
            },
            mounted() {
                const self = this;
                // $(window).on('resize', self.getWindowSize)
                self.getWindowSize();
            },
            unmounted() {
                // $(window).on('resize', this.getWindowSize)

            },
            template: `
<el-dialog
    ref="dialogInstance"
    v-model="visibleDialog"
    :title="dialogTitle"
    destroy-on-close
    :z-index="zIndex"
    v-bind="options"
    class="element-dialog"
  >
  <template #header="{ close, titleId, titleClass }">
    <div class="element-dialog-header">
        <el-breadcrumb separator="->" class="element-dialog-breadcrumb">
          <el-breadcrumb-item v-for="(el, index) in breadcrumb">{{ el }}</el-breadcrumb-item>
        </el-breadcrumb>  
        <el-button text @click="HandleFullscreen" size="small" class="element-dialog-header-fullscreen-button"> <el-icon ><i class="iconfont" :class="fullScreenIcon" ></i></el-icon></el-button>
    </div>  
  </template>
  <iframe v-if="visibleDialog" scrolling="auto" frameborder="0" :src="url" style="width:100%;" 
        :element-dialog-id="dialogId"
        :style="{ height: options.fullscreen ? windowHeight - 70 : windowHeight - 250 }"></iframe>
</el-dialog>
        `
        });

        instance.open = function(resolve, reject) {
            this._instance.proxy.open(resolve, reject);
        }
        instance.close = function() {
            this._instance.proxy.close();

        }
        instance.use(ElementPlus, { locale: ElementPlusLocaleZhCn })
        for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
            instance.component(key, component)
        }
        if (CardComponents) {
            for (const [key, component] of Object.entries(CardComponents)) {
                instance.component(key, component)
            }
        }
        const div = options.inner ? window.document.createElement('div') : window.top.document.createElement('div')
        div.setAttribute('id', 'div' + dialogId)
        options.inner ? window.document.body.append(div) : window.top.document.body.append(div)

        instance._div = div;
        instance.mount(div)

        // 返回异步操作回调
        return new Promise((resolve, reject) => {
            // 返回前打开弹框
            instance.open(resolve, reject);
        });
    }

    function closeDialog() {
        try {
            $(window.parent.document).find('iframe').each(function(i, el){
                if (el.contentWindow.document == document) {
                    let dialogId = $(el).attr('element-dialog-id')
                    if (window.top._elementInstances[dialogId]) {
                        window.top._elementInstances[dialogId].reject.apply(null);
                        window.top._elementInstances[dialogId].close()
                    }
                }
            })
        } catch(e) {
            console.error("关闭弹框时异常" ,e)
            // ElementDialog.closeDialog();
        }
    }

    function dialogCallback() {
        const args = arguments
        try {
            $(window.parent.document).find('iframe').each(function(i, el){
                if (el.contentWindow.document == document) {
                    let dialogId = $(el).attr('element-dialog-id')
                    if (window.top._elementInstances[dialogId]) {
                        window.top._elementInstances[dialogId].resolve.apply(null, args);
                        // 执行后关闭
                        window.top._elementInstances[dialogId].close()
                    }
                }
            })
        } catch(e) {
            console.error("弹框回调执行异常" ,e)
        }
    }

    exports.ElementDialog = {
        createDialog,
        createFullDialog : function(title, url, options = { width: '70%', top: '10vh'}) {
            return createDialog(title, url, options = { fullscreen: true, top: '10vh'})
        },
        createInnerFullDialog : function(title, url, options = { width: '70%', top: '10vh'}) {
            return createDialog(title, url, options = { fullscreen: true, top: '10vh', inner: true})
        },
        closeDialog,
        callback : dialogCallback,
    };
}));
