(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    window.FILTER_OP_TYPE = [{"enname": "lk", "cnname": "包含"}, {"enname": "nlk", "cnname": "不包含"}, {"enname": "i", "cnname": "包含"}, {"enname": "ni", "cnname": "不包含"}, {"enname": "btw", "cnname": "介于"}, {"enname": "eq", "cnname": "等于"}, {"enname": "gt", "cnname": "大于"}, {"enname": "ge", "cnname": "大于等于"}, {"enname": "lt", "cnname": "小于"}, {"enname": "le", "cnname": "小于等于"}];
    exports.FilterButton = {
        props: {
            modelValue: Boolean,
            disabled: Boolean,
            count: Number,
        },
        data(){
            return {
                visible: false,

            }
        },
        methods: {


        },
        computed:{
            value: {
                get() {
                    return this.modelValue
                },
                set(val) {
                    this.$emit('update:modelValue', val)
                }
            }
        },
        mounted() {
        },
        unmounted() {
        },
        template: `
<el-button class="button" text size="small" @click="value = !value" :disabled="disabled">
    <el-icon>
        <i class="icon iconfont icon-shousuo1" v-if="value"></i>
        <component is="Filter" v-else></component>
    </el-icon>
    过滤条件
    <span class="filter-btn-suffix" v-if="count>0">{{count}}</span>
</el-button>
        `
    }
}));
