(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.OwnDatePicker = {
        props: {
            modelValue: String,
            type: {
                type: String,
                default: 'date'
            },
            format: {
                type: String,
                default: 'YYYY-MM-DD'
            },
            valueFormat: {
                type: String,
                default: 'YYYY-MM-DD'
            },
            placeholder: String,
            disabled: Boolean,
            readonly: Boolean,
            editable: Boolean,
            clearable: Boolean,
        },
        emits: ['update:modelValue', 'change'],
        data(){
            return {
                formItem: undefined
            }
        },
        methods: {
            handlerChange(val) {
                this.$emit('change', val)
                const { formItem } = this;
                formItem && formItem.validate();
            },
        },
        computed:{
            value: {
                get() {
                    return (this.modelValue || '') + ''
                },
                set(value) {
                    this.$emit('update:modelValue', value)
                }
            },
            popperOptions() {
                return window.EL_POPPER_OPTIONS
            }
        },
        mounted() {
            this.formItem = vue.inject(ElementPlus.formItemContextKey)
        },
        unmounted() {

        },
        template: `
<el-date-picker v-model="value"  
    :placeholder="placeholder" :popper-options="popperOptions" 
    :clearable="clearable" 
    :editable="editable" 
    :disabled="disabled || readonly"
    :type="type"
    :format="format"
    :value-format="valueFormat"
    @change="handlerChange"
     >
    
</el-date-picker>
        `
    }
}));
