(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {


    // 动态组件
    exports.SDynamicLogView = {
        props: {
            serviceUrl: {
                type: String,
                default: '/allincloud'
            },
            indexKey: String,
            dlType1: String,
            dlType2: String,
            noScroll: Boolean,
            styleObject: Object,
            startDate: String
        },
        data(){
            return {
                dgUrl: '/api/s/dynamic/logs',
                // 卡片内容数据
                queryParams: {
                    indexKey: '',
                    dlType1: '',
                    dlType2: '',
                    startDlDate: this.startDate,
                },
                pageInfo:{
                    page: 1,
                    size: 10,
                    total: 0
                },
                all: '',
                allName: 'all',
                tableData: [],

            }
        },
        watch: {
            indexKey: function(val){
                this.queryParams.indexKey = val
                this.queryList();
            },
            dlType1: function(val){
                this.queryParams.dlType1 = val
                this.queryList();
            },
            dlType2: function(val){
                this.queryParams.dlType2 = val
                this.queryList();
            },
            startDate: function(val){
                this.queryParams.startDlDate = val
                this.queryList();
            }
        },
        methods: {
            queryList() {
                const self = this;
                self.loading = true;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all
                $.restfulPostForm(self.serviceUrl + self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    self.tableData = data.rows;
                    self.loading = false;
                    self.$emit('loadSuccess')
                }, function(){ self.loading = false; }, true);
            },
            loadMore() {
                const self = this;
                if (self.tableData.length == self.pageInfo.total || !self.serviceUrl) {
                    return;
                }
                self.loading = true;
                self.pageInfo.page += 1;
                let params = {
                    ...Vue.unref(self.pageInfo),
                    ...Vue.unref(self.queryParams)
                }
                params[self.allName] = self.all
                $.restfulPostForm(self.serviceUrl + self.dgUrl, params, function(data){
                    self.pageInfo.total = data.total;
                    Array.prototype.push.apply(self.tableData, data.rows)
                    self.loading = false;
                    self.$emit('loadSuccess')
                }, function(){ self.loading = false; }, true);
            },
            scroll({scrollTop}) {
                this.loadMore();
            },
            splitDlText(dlText) {
                return (dlText || '' ).split("\n");
            },
            formatterDlText(dlText, item) {
                let bizkey = item.dlBizkey;
                if (dlText.startsWith('删除')) {
                    return dlText;
                }
                let html = dlText.replace(`#${bizkey}`, `<span class="timeline-linked">#${bizkey}</span>`)
                return html;
            },
            handlerItemClick(event, row) {
                window.SDynamicUtil.handlerDynamicItemClick(event, row);
            },
            cardPropsChange() {
                const self = this;
                if (self.appInfos) {
                    self.localCard.cardProps = JSON.stringify(Vue.unref(self.cardPropsMap));
                }
            },
            refreshCard() {
                const self = this;
                self.pageInfo.page = 1;
                self.queryList();
            },
        },
        computed:{
            DIC(){
                return {
                    "DL_TYPE1" : [
                        {enname: 'portal', cnname: '基础设施'},
                        {enname: 'rdm', cnname: '研发管理'},
                        {enname: 'sam', cnname: '技术资产'},
                        {enname: 'dam', cnname: '数据资产'},
                        {enname: 'apdpaas', cnname: '应用开发'},
                    ],
                    "DYNAMIC_LOG_TYPE" : window["DYNAMIC_LOG_TYPE"] || ''
                }
            },
        },
        mounted() {
            const self = this;
            this.queryParams.indexKey = this.indexKey;
            this.queryParams.dlType1 = this.dlType1;
            this.queryParams.dlType2 = this.dlType2;
        },
        unmounted() {

        },
        template: `
<div>
    <template v-if="noScroll">
        <el-row >
            <el-col :span="24" >
                <el-empty v-if="tableData.length == 0" description="暂无动态"></el-empty>
                <el-timeline>
                    <el-timeline-item
                            v-for="(item, index) in tableData"
                            :key="index"
                            placement="top"
                            type="primary"
                            hollow
                            :timestamp="item.dlDate + ' ' +item.dlTime"
                    >
                        <div class="timeline-item" @click="handlerItemClick($event, item)">
                            <div class="timeline-user">{{item.userName}}</div>
                            <div class="timeline-text-div">
                                <div v-for="(dlText, tIndex) in splitDlText(item.dlText)" class="timeline-text" v-html="formatterDlText(dlText, item)"></div>
                            </div>
                        </div>
                    </el-timeline-item>
                </el-timeline>
    
                <div style="text-align: center;">
                    <el-button style="width: 200px" v-if="tableData.length < pageInfo.total" v-loading="loading" type="info" @click="loadMore">加载更多</el-button>
                </div>
            </el-col>
        </el-row>
    </template>
    <template v-if="!noScroll">
        <el-scrollbar :style="styleObject" @scroll="scroll">
            <el-row>
                <el-col :span="24" >
                    <el-empty v-if="tableData.length == 0" description="暂无动态"></el-empty>
                    <el-timeline>
                        <el-timeline-item
                                v-for="(item, index) in tableData"
                                :key="index"
                                placement="top"
                                type="primary"
                                hollow
                                :timestamp="item.dlDate + ' ' +item.dlTime"
                        >
                            <div class="timeline-item" @click="handlerItemClick($event, item)">
                                <div class="timeline-user">{{item.userName}}</div>
                                <div class="timeline-text-div">
                                    <div v-for="(dlText, tIndex) in splitDlText(item.dlText)" class="timeline-text" v-html="formatterDlText(dlText, item)"></div>
                                </div>
                            </div>
                        </el-timeline-item>
                    </el-timeline>
                </el-col>
            </el-row>
        </el-scrollbar>
    </template>
    
    <div class="card-bottom-move" v-if="!fixedFlag">
        <el-button class="card-bottom-move-btn" text icon="BottomRight" :style="moveBtnStyle" size="small" @mousedown="resizeCardStart"></el-button>
    </div>
</div>
        `
    }

}));