(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue'), require('jQuery'), require('lodash'), require('loadjs')) :
        typeof define === 'function' && define.amd ? define(['exports', 'vue', 'jQuery', 'lodash', 'loadjs'], factory) :
            (global = typeof globalThis !== 'undefined' ? globalThis : global || this, factory(global.CardComponents, global.Vue, global.$, global._, global.loadjs));
})(this, (function (exports, vue, $, _) {

    exports.PageHeader = {
        props: {
            'breadcrumb': Array,
            'cardHeader': Boolean,
            'rightCol': {
                default: 6,
                type: Number,
            }
        },
        inject: ['DIC'],
        data(){
            return {
            }
        },
        methods: {
            titleClickHandler(e) {
                this.$emit('titleClick', e);
            }
        },
        computed:{
            title() {
                if (_.isArray(this.breadcrumb ) ) {
                    return this.breadcrumb.join("->")
                } else {
                    return this.breadcrumb;
                }
            }
        },
        mounted() {

        },
        unmounted() {

        },
        template: `
<el-row style="padding-top: 15px;" v-if="!cardHeader">
    <el-col :span="24 - rightCol" style="display:flex;">
        <slot name="title"></slot>
        <div class="table-title" style="cursor: pointer;" v-if="!$slots.title" @click="titleClickHandler">{{title}}</div>
        <slot name="left"></slot>
    </el-col>
    <el-col :span="rightCol" style="display:flex; justify-content: flex-end;">
        <div class="header-tool">
            <slot name="right"></slot>
        </div>
    </el-col>
</el-row>
<div class="card-header" v-else>
    <slot name="title"></slot>
    <span v-if="!$slots.title" style="cursor: pointer;" @click="titleClickHandler"><i class="drag-handler iconfont icon-move" ></i>{{title}}</span>
    <div style="margin-top:1px;">
        <slot name="right"></slot>
    </div>
</div>
        `, _designerRule: {
            //插入菜单位置
            menu: 'main',
            //图标
            icon: 'iconfont icon-yonghufill',
            //名称
            label: '页面标题',
            //id,唯一!
            name: 'PageHeader',
            //是否可以操作, 除了容器类组件建议为true !
            mask: true,
            //支持组件验证, 值的类型
            validate: ['string'],
            //定义组件的事件
            event: ['change', 'visibleChange', 'selectLabel'],
            //定义组件的渲染规则
            rule({t}) {
                //组件的生成规则
                return {
                    type: 'PageHeader',
                    //field不能重复!!!
                    field: JLUtil.uniqueId(),
                    title: '下拉',
                    info: '',
                    $required: false,
                    props: {},
                };
            },
            //组件的属性配置
            props(_, {t}) {
                return [
                    {
                        type: 'switch',
                        title: '是否禁用',
                        field: 'disabled'
                    },
                    {
                        type: 'switch',
                        title: '是否可清除',
                        field: 'clearable'
                    },
                    {
                        type: 'switch',
                        title: '是否多选',
                        field: 'multiple'
                    },
                ];
            }
        }
    }
}));
