(function(mod) {
   mod(CodeMirror);
})(function(CodeMirror) {
    "use strict";

    CodeMirror.defineMode("cond", function(config, parserConfig) {
        return {
            // 文档初始化时 调用一次
            startState: function(base) {
                return {base: base, inString: false}
            },
            // 必选，返回高亮样式 行内文本变化回调
            token:  function(stream, state) {
                if (state.inString) {
                    var ch = stream.next();
                    if (ch == "'") {
                        state.inString = false;
                    }
                    return 'string';
                }
                if (stream.eatSpace()) {
                    return null;
                }
                if (stream.match(/并|且|非|或/)) {
                    var t = stream.eat(/并|且|非|或/);
                    return 'keyword';
                }
                if (stream.match(/\(|\)/)) {
                    var t = stream.eat(/\(|\)/);
                    return 'bracket';
                }
                var ch = stream.next();
                if (ch =="'") {
                    state.inString = true;
                    return 'string';
                } else if (ch == '$') {
                    var str = stream.match(/\S+/, true);
                    if (str && str[0].startsWith('字符串')) {
                        return 'def';
                    } else if (str) {
                        return 'variable-2';
                    }
                } else if (ch == "." && stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)) {
                    return 'number';
                } else if (ch == "." && stream.match("..")) {
                    return 'meta';
                } else if (/[\[\]{}\(\),;\:\.]/.test(ch)) {
                    return null;
                } else if (ch == "=" && stream.eat(">")) {
                    return 'operator';
                } else if (ch == "0" && stream.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/)) {
                    return 'number';
                } else if (/\d/.test(ch)) {
                    stream.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/);
                    return 'number';
                }

            },
            // 可选，定义缩进规则，返回缩进空格数  输入回车换行时回调
            indent: function(state, textAfter) {
                // console.log('indent', state, textAfter)
                return 0;
            },
        };
    })

    CodeMirror.defineMIME("text/cond","cond");
})