/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.sdp.dmcenter.plugin;

import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdp.dmcenter.plugin.ISQLScriptPlugin;
import com.irdstudio.sdp.dmcenter.service.facade.ModelTableFieldService;
import com.irdstudio.sdp.dmcenter.service.facade.ModelTableInfoService;
import com.irdstudio.sdp.dmcenter.service.vo.ModelTableFieldVO;
import com.irdstudio.sdp.dmcenter.service.vo.ModelTableInfoVO;
import java.util.List;

public class MysqlScriptPlugin
implements ISQLScriptPlugin {
    @Override
    public String generateDDLScript(String objectId, boolean genDrop) {
        ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean((String)"modelTableInfoService");
        ModelTableInfoVO mtiv = new ModelTableInfoVO();
        mtiv.setObjectId(objectId);
        mtiv = modelTableInfoService.queryByPk(mtiv);
        return this.generateDDLScript(mtiv, genDrop);
    }

    @Override
    public String generateDDLScript(ModelTableInfoVO mtiv, boolean genDrop) {
        ModelTableFieldService mtfs = (ModelTableFieldService)SpringContextUtils.getBean((String)"modelTableFieldService");
        ModelTableFieldVO mtfv = new ModelTableFieldVO();
        mtfv.setObjectId(mtiv.getObjectId());
        List<ModelTableFieldVO> mtfvList = mtfs.queryModelTableField(mtfv);
        StringBuffer ddl = new StringBuffer();
        StringBuffer keyFields = new StringBuffer();
        ddl.append("DROP TABLE IF EXISTS ").append(mtiv.getObjectCode()).append(";\n");
        ddl.append("CREATE TABLE IF NOT EXISTS ").append(mtiv.getObjectCode()).append("(\n");
        for (ModelTableFieldVO field : mtfvList) {
            String fieldCode = field.getFieldCode().toUpperCase();
            if ("Y".equals(field.getIsPk())) {
                keyFields.append(fieldCode).append(",");
            }
            ddl.append('\t').append(fieldCode).append(" ").append(field.getFieldType());
            if (field.getFieldLength() > 0) {
                ddl.append("(").append(field.getFieldLength());
                if (field.getFieldPrecision() > 0) {
                    ddl.append(",").append(field.getFieldPrecision());
                }
                ddl.append(")");
            }
            if ("Y".equals(field.getIsPk())) {
                ddl.append(" NOT NULL");
            } else {
                ddl.append(" NULL");
            }
            ddl.append(" COMMENT '").append(field.getFieldName()).append("',\n");
        }
        if (keyFields.lastIndexOf(",") != -1) {
            ddl.append("\tPRIMARY KEY (").append(keyFields.deleteCharAt(keyFields.length() - 1)).append("))\n");
        }
        if (ddl.length() > 11) {
            ddl.deleteCharAt(ddl.length() - 2);
        }
        ddl.append(") ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='").append(mtiv.getObjectName()).append("';\n");
        return ddl.toString().toLowerCase();
    }

    @Override
    public String generateInsertScript(String objectId) {
        return null;
    }

    @Override
    public String generateUpdateScript(String objectId) {
        return null;
    }

    @Override
    public String generateDeleteScript(String objectId) {
        return null;
    }
}

