/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.devcenter.openapi.client;

import cn.utrust.fintech.devcenter.openapi.client.DeveloperProperties;
import cn.utrust.fintech.devcenter.openapi.client.MyJacksonDecoder;
import cn.utrust.fintech.devcenter.openapi.client.MyJacksonEncoder;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MyInvocationHandlerFactory;
import feign.Request;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ClientFactory {
    private String serverHost;
    private ConcurrentHashMap<Class<?>, Object> clientMap = new ConcurrentHashMap();
    private DeveloperProperties developerProperties;
    private int maxAttempts = 1;
    private int connectTimeoutMillis = 10000;
    private int readTimeoutMillis = 60000;

    public ClientFactory(String serverHost) {
        this.serverHost = serverHost;
    }

    public static ClientFactory getInstance(String configFilePath) {
        InputStream is;
        ClientFactory.assertNotBlank(configFilePath, "\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        if (configFilePath.startsWith("classpath:")) {
            String filePath = configFilePath.replaceFirst("classpath:", "");
            is = ClientFactory.class.getClassLoader().getResourceAsStream(filePath);
            if (is == null) {
                throw new RuntimeException("\u6587\u4ef6" + configFilePath + "\u4e0d\u5b58\u5728");
            }
        } else {
            try {
                is = new FileInputStream(configFilePath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", e);
        }
        DeveloperProperties developerProperties = new DeveloperProperties();
        developerProperties.setAppId(properties.getProperty("appId"));
        developerProperties.setPlatformHost(properties.getProperty("platformHost"));
        developerProperties.setPlatformPublicKey(properties.getProperty("platformPublicKey"));
        developerProperties.setPrivateKey(properties.getProperty("privateKey"));
        return ClientFactory.getInstance(developerProperties);
    }

    public static ClientFactory getInstance(DeveloperProperties developerProperties) {
        ClientFactory.assertNotBlank(developerProperties.getAppId(), "appId\u4e0d\u80fd\u4e3a\u7a7a");
        ClientFactory.assertNotBlank(developerProperties.getPlatformHost(), "platformHost(\u4e0d\u80fd\u4e3a\u7a7a");
        ClientFactory.assertNotBlank(developerProperties.getPlatformPublicKey(), "platformPublicKey\u4e0d\u80fd\u4e3a\u7a7a");
        ClientFactory.assertNotBlank(developerProperties.getPrivateKey(), "privateKey\u4e0d\u80fd\u4e3a\u7a7a");
        ClientFactory factory = new ClientFactory(developerProperties.getPlatformHost());
        factory.developerProperties = developerProperties;
        return factory;
    }

    public ClientFactory setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts > 1 ? maxAttempts : 1;
        return this;
    }

    public ClientFactory setConnectTimeoutMillis(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 1) {
            throw new IllegalArgumentException("\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1\u6beb\u79d2");
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public ClientFactory setReadTimeoutMillis(int readTimeoutMillis) {
        if (readTimeoutMillis < 1) {
            throw new IllegalArgumentException("\u8bfb\u8d85\u65f6\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1\u6beb\u79d2");
        }
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    private static void assertNotBlank(String target, String errorMessage) {
        if (target == null || "".equals(target)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public <T> T getClient(Class<T> clazz) {
        if (this.clientMap.get(clazz) != null) {
            return (T)this.clientMap.get(clazz);
        }
        Retryer.Default retryer = new Retryer.Default(100L, TimeUnit.SECONDS.toMillis(1L), this.maxAttempts);
        Request.Options options = new Request.Options(this.connectTimeoutMillis, this.readTimeoutMillis);
        Object client = Feign.builder().invocationHandlerFactory((InvocationHandlerFactory)new MyInvocationHandlerFactory(this.developerProperties)).options(options).decoder((Decoder)new MyJacksonDecoder(this.developerProperties)).encoder((Encoder)new MyJacksonEncoder(this.developerProperties)).retryer((Retryer)retryer).target(clazz, this.serverHost);
        this.clientMap.put(clazz, client);
        return (T)client;
    }
}

