/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.devcenter.openapi.client;

import cn.utrust.fintech.devcenter.openapi.client.ApiInvokeException;
import cn.utrust.fintech.devcenter.openapi.client.DeveloperProperties;
import cn.utrust.fintech.devcenter.openapi.client.OpenApiResponseListener;
import cn.utrust.fintech.devcenter.openapi.client.OpenApiResult;
import cn.utrust.fintech.devcenter.openapi.client.util.ClientInitUtil;
import cn.utrust.fintech.devcenter.openapi.client.util.RSAUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class MyJacksonDecoder
extends JacksonDecoder {
    private ObjectMapper om = new ObjectMapper();
    private DeveloperProperties developerProperties;

    public MyJacksonDecoder(DeveloperProperties developerProperties) {
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.developerProperties = developerProperties;
    }

    public Object decode(Response response, Type type) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(response.body().asReader());
        StringBuilder sBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            sBuilder.append(line);
        }
        String content = sBuilder.toString();
        this.listen(content);
        OpenApiResult openApiResult = (OpenApiResult)this.om.readValue(content, OpenApiResult.class);
        this.verifySign(openApiResult);
        Object object = null;
        if (openApiResult.getData() != null && !"".equals(openApiResult.getData())) {
            Response newRsp = response.toBuilder().body(openApiResult.getData(), Charset.forName("UTF-8")).build();
            object = super.decode(newRsp, type);
        }
        if (!"0".equals(openApiResult.getRspCode()) && !"000000".equals(openApiResult.getRspCode())) {
            throw new ApiInvokeException(openApiResult.getRspCode(), openApiResult.getRspMsg(), object);
        }
        return object;
    }

    public void verifySign(OpenApiResult openApiResult) {
        String origSignData = openApiResult.getRspCode() + openApiResult.getRspMsg() + (openApiResult.getData() == null ? "" : openApiResult.getData()) + openApiResult.getTimestamp();
        try {
            if (openApiResult.getSign() == null || "".equals(openApiResult.getSign())) {
                if ("999999".equals(openApiResult.getRspCode())) {
                    return;
                }
                throw new RuntimeException("\u7b7e\u540d\u4e0d\u6b63\u786e");
            }
            boolean flag = RSAUtils.verify(origSignData.getBytes("UTF-8"), this.developerProperties.getPlatformPublicKey(), openApiResult.getSign());
            if (!flag) {
                throw new RuntimeException("\u7b7e\u540d\u4e0d\u6b63\u786e");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public void listen(final String content) {
        try {
            final OpenApiResponseListener openApiResponseListener = ClientInitUtil.getOpenApiResponseListener();
            if (openApiResponseListener != null) {
                if (ClientInitUtil.isAsyncListen()) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                openApiResponseListener.listen(MyJacksonDecoder.this.om.writeValueAsString((Object)content));
                            }
                            catch (JsonProcessingException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                } else {
                    try {
                        openApiResponseListener.listen(this.om.writeValueAsString((Object)content));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

