/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.devcenter.openapi.client;

import cn.utrust.fintech.devcenter.openapi.client.DeveloperProperties;
import cn.utrust.fintech.devcenter.openapi.client.OpenApiParam;
import cn.utrust.fintech.devcenter.openapi.client.OpenApiRequestListener;
import cn.utrust.fintech.devcenter.openapi.client.util.ClientInitUtil;
import cn.utrust.fintech.devcenter.openapi.client.util.RSAUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.RequestTemplate;
import feign.jackson.JacksonEncoder;
import java.lang.reflect.Type;
import java.util.Date;

public class MyJacksonEncoder
extends JacksonEncoder {
    private ObjectMapper om = new ObjectMapper();
    private DeveloperProperties developerProperties;

    public MyJacksonEncoder(DeveloperProperties developerProperties) {
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.developerProperties = developerProperties;
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) {
        try {
            String jsonStr = this.om.writeValueAsString(object);
            long timestamp = new Date().getTime();
            String origSignData = this.developerProperties.getAppId() + jsonStr + timestamp;
            String sign = RSAUtils.sign(origSignData.getBytes("UTF-8"), this.developerProperties.getPrivateKey());
            OpenApiParam param = new OpenApiParam();
            param.setAppId(this.developerProperties.getAppId());
            param.setData(jsonStr);
            param.setTimestamp(String.valueOf(timestamp));
            param.setSign(sign);
            super.encode((Object)param, OpenApiParam.class, template);
            this.listen(param);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void listen(final Object object) {
        try {
            final OpenApiRequestListener openApiRequestListener = ClientInitUtil.getOpenApiRequestListener();
            if (openApiRequestListener != null) {
                if (ClientInitUtil.isAsyncListen()) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                openApiRequestListener.listen(MyJacksonEncoder.this.om.writeValueAsString(object));
                            }
                            catch (JsonProcessingException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                } else {
                    try {
                        openApiRequestListener.listen(this.om.writeValueAsString(object));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

