/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.MethodMetadata;
import feign.Param;
import feign.RequestTemplate;
import feign.Util;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BuildTemplateByEmptyResolvingArgs
implements RequestTemplate.Factory {
    protected final MethodMetadata metadata;
    private final Encoder encoder;
    private final Map<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();

    BuildTemplateByEmptyResolvingArgs(MethodMetadata metadata, Encoder encoder) {
        this.metadata = metadata;
        this.encoder = encoder;
        if (metadata.indexToExpander() != null) {
            this.indexToExpander.putAll(metadata.indexToExpander());
            return;
        }
        if (metadata.indexToExpanderClass().isEmpty()) {
            return;
        }
        for (Map.Entry indexToExpanderClass : metadata.indexToExpanderClass().entrySet()) {
            try {
                this.indexToExpander.put((Integer)indexToExpanderClass.getKey(), (Param.Expander)((Class)indexToExpanderClass.getValue()).newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public RequestTemplate create(Object[] argv) {
        RequestTemplate mutable = new RequestTemplate(this.metadata.template());
        if (this.metadata.urlIndex() != null) {
            int urlIndex = this.metadata.urlIndex();
            Util.checkArgument((argv[urlIndex] != null ? 1 : 0) != 0, (String)"URI parameter %s was null", (Object[])new Object[]{urlIndex});
            mutable.insert(0, (CharSequence)String.valueOf(argv[urlIndex]));
        }
        LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : this.metadata.indexToName().entrySet()) {
            int i = (Integer)entry.getKey();
            Object value = argv[(Integer)entry.getKey()];
            if (value == null) continue;
            if (this.indexToExpander.containsKey(i)) {
                value = this.expandElements(this.indexToExpander.get(i), value);
            }
            for (String name : (Collection)entry.getValue()) {
                varBuilder.put(name, value);
            }
        }
        RequestTemplate template = this.resolve(argv, mutable, varBuilder);
        if (this.metadata.queryMapIndex() != null) {
            template = this.addQueryMapQueryParameters((Map)argv[this.metadata.queryMapIndex()], template);
        }
        if (this.metadata.headerMapIndex() != null) {
            template = this.addHeaderMapHeaders((Map)argv[this.metadata.headerMapIndex()], template);
        }
        return template;
    }

    private Object expandElements(Param.Expander expander, Object value) {
        if (value instanceof Iterable) {
            return this.expandIterable(expander, (Iterable)value);
        }
        return expander.expand(value);
    }

    private List<String> expandIterable(Param.Expander expander, Iterable value) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object element : value) {
            if (element == null) continue;
            values.add(expander.expand(element));
        }
        return values;
    }

    private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutable) {
        for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    values.add(nextObject == null ? null : nextObject.toString());
                }
            } else {
                values.add(currValue == null ? null : currValue.toString());
            }
            mutable.header(currEntry.getKey(), values);
        }
        return mutable;
    }

    private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutable) {
        for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            boolean encoded = this.metadata.queryMapEncoded();
            Object currValue = currEntry.getValue();
            if (currValue instanceof Iterable) {
                for (Object nextObject : (Iterable)currValue) {
                    values.add(nextObject == null ? null : (encoded ? nextObject.toString() : RequestTemplate.urlEncode((Object)nextObject.toString())));
                }
            } else {
                values.add(currValue == null ? null : (encoded ? currValue.toString() : RequestTemplate.urlEncode((Object)currValue.toString())));
            }
            mutable.query(true, encoded ? currEntry.getKey() : RequestTemplate.urlEncode((Object)currEntry.getKey()), values);
        }
        return mutable;
    }

    protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
        HashMap body = new HashMap();
        try {
            this.encoder.encode(body, HashMap.class, mutable);
        }
        catch (EncodeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new EncodeException(e.getMessage(), (Throwable)e);
        }
        LinkedHashMap variableToEncoded = new LinkedHashMap();
        for (Map.Entry entry : this.metadata.indexToEncoded().entrySet()) {
            Collection names = (Collection)this.metadata.indexToName().get(entry.getKey());
            for (String name : names) {
                variableToEncoded.put(name, entry.getValue());
            }
        }
        return mutable.resolve(variables, variableToEncoded);
    }
}

