/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.tango.sdk.client.dto;

import cn.utrust.fintech.tango.sdk.client.dto.BaseReqI;
import java.io.Serializable;

public class FileTokenRequestDTO
implements BaseReqI,
Serializable {
    private String source;
    private String name;
    private String directory;
    private Boolean saveAsRealName;
    private Boolean saveAsVirtualDirectory;
    private Integer saveServerType;
    private Boolean override;
    private String remark;

    public String toString() {
        return "FileTokenRequestDTO{source='" + this.source + '\'' + ", name='" + this.name + '\'' + ", directory='" + this.directory + '\'' + ", saveAsRealName=" + this.saveAsRealName + ", saveAsVirtualDirectory=" + this.saveAsVirtualDirectory + ", saveServerType=" + this.saveServerType + ", override=" + this.override + ", remark='" + this.remark + '\'' + '}';
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getName() {
        if (this.name != null && this.name.startsWith("/")) {
            this.name = this.name.substring(1, this.name.length());
        }
        if (this.name != null && this.name.endsWith("/")) {
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDirectory() {
        StringBuilder sb = new StringBuilder();
        sb = !this.directory.startsWith("/") ? sb.append("/").append(this.directory) : sb.append(this.directory);
        if (sb.toString().endsWith("/")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isSaveAsRealName() {
        return this.saveAsRealName;
    }

    public void setSaveAsRealName(boolean saveAsRealName) {
        this.saveAsRealName = saveAsRealName;
    }

    public void setSaveAsVirtualDirectory(boolean saveAsVirtualDirectory) {
        this.saveAsVirtualDirectory = saveAsVirtualDirectory;
    }

    public Boolean getSaveAsVirtualDirectory() {
        return this.saveAsVirtualDirectory;
    }

    public void setSaveAsVirtualDirectory(Boolean saveAsVirtualDirectory) {
        this.saveAsVirtualDirectory = saveAsVirtualDirectory;
    }

    public Integer getSaveServerType() {
        return this.saveServerType;
    }

    public void setSaveServerType(Integer saveServerType) {
        this.saveServerType = saveServerType;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRealNameFullPath() {
        return this.source + FileTokenRequestDTO.formatDir(this.directory) + this.name;
    }

    public String getUUIDFullPath(String uuid) {
        return this.source + FileTokenRequestDTO.formatDir(this.directory) + uuid + this.getSuffix();
    }

    public String getSuffix() {
        return this.name != null ? this.name.substring(this.name.lastIndexOf(".") + 1).toLowerCase() : null;
    }

    public static String formatDir(String dir) {
        if (!dir.startsWith("/")) {
            dir = "/" + dir;
        }
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }
}

