/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.tango.sdk.client.util;

import cn.utrust.fintech.tango.sdk.client.dto.ReturnWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class HttpRequestUtil {
    private static CloseableHttpClient httpClient = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRequeset(String url, String content) {
        CloseableHttpResponse resp = null;
        try {
            HttpPost post = new HttpPost(url);
            StringEntity entity = new StringEntity(content, "UTF-8");
            entity.setChunked(true);
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-Type", "application/json");
            resp = httpClient.execute((HttpUriRequest)post);
            if (resp != null) {
                HttpEntity ent = resp.getEntity();
                if (ent != null) {
                    String string = EntityUtils.toString((HttpEntity)ent);
                    return string;
                }
                System.out.println("post response is empty");
            }
        }
        catch (Exception e) {
            System.out.println("post exception: " + e.getMessage());
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequeset(String url) {
        CloseableHttpResponse resp = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            resp = httpClient.execute((HttpUriRequest)httpGet);
            if (resp != null) {
                HttpEntity ent = resp.getEntity();
                if (ent != null) {
                    String string = EntityUtils.toString((HttpEntity)ent);
                    return string;
                }
                System.out.println("get response is empty ,url:" + url);
            }
        }
        catch (Exception e) {
            System.out.println("get exception ,url:" + url);
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (Exception exception) {}
            }
        }
        return "";
    }

    public static File downloadPicture(String urlList) {
        URL url = null;
        boolean imageNumber = false;
        try {
            int length;
            url = new URL(urlList);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            String imageName = "D:/download.jpg";
            FileOutputStream fileOutputStream = new FileOutputStream(new File(imageName));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = dataInputStream.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            byte[] context = output.toByteArray();
            fileOutputStream.write(output.toByteArray());
            dataInputStream.close();
            fileOutputStream.close();
            return new File(imageName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReturnWrapper<Map<String, Object>> postFile(String uploadUrl, Map<String, Object> params, File file) throws ClientProtocolException, IOException {
        ReturnWrapper<Map<String, Object>> returnWrapper = new ReturnWrapper<Map<String, Object>>();
        String result = "";
        HttpPost httpPost = new HttpPost(uploadUrl);
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setCharset(Charset.forName("UTF-8")).setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("file", file);
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8)));
            }
            HttpEntity reqEntity = builder.build();
            httpPost.setEntity(reqEntity);
            CloseableHttpResponse response = HttpClients.createDefault().execute((HttpUriRequest)httpPost);
            System.out.println("uploadUrl:" + uploadUrl + "  ,status:" + response.getStatusLine());
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            JSONObject jsonObject = new JSONObject(result);
            System.out.println("uploadUrl:" + uploadUrl + "  ,body:" + result);
            if (response.getStatusLine().getStatusCode() == 200) {
                System.out.println("\u4e0a\u4f20\u6210\u529f");
                returnWrapper.setCode((Integer)jsonObject.get("code"));
                returnWrapper.setMessage((String)jsonObject.get("message"));
                returnWrapper.setData(jsonObject.getJSONObject("data").toMap());
            }
            returnWrapper.setCode(-1);
            returnWrapper.setMessage("\u7f51\u7edc\u5f02\u5e38\uff0c\u4e0a\u4f20\u5931\u8d25");
            System.out.println("\u534f\u8bae\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:");
        }
        catch (Exception ex) {
            returnWrapper.setCode(-1);
            returnWrapper.setMessage("\u4e0a\u4f20\u5931\u8d25");
            ex.printStackTrace();
        }
        finally {
            httpPost.releaseConnection();
            return returnWrapper;
        }
    }

    static {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(15000).setSocketTimeout(15000).build();
        httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }
}

