/*
 * Decompiled with CFR 0.152.
 */
package cn.utrust.fintech.tango.sdk.client.util;

import cn.utrust.fintech.tango.sdk.client.dto.DirectoryTokenRequestDTO;
import cn.utrust.fintech.tango.sdk.client.dto.FileTokenRequestDTO;
import cn.utrust.fintech.tango.sdk.client.dto.ReadFileRequestDTO;
import cn.utrust.fintech.tango.sdk.client.dto.ReturnWrapper;
import cn.utrust.fintech.tango.sdk.client.util.CommonUtil;
import cn.utrust.fintech.tango.sdk.client.util.HttpRequestUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.Callback;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class TangoUploadUtil {
    private static String imageSuffix = "gif,jpg,jpeg,png,bmp";
    public static final int SELF_NODE = 1;
    public static final int OSS_NODE = 3;
    private static String BASE_URL = "http://127.0.0.1:80";

    public static ReturnWrapper<Map<String, Object>> fileAccessToken(FileTokenRequestDTO fileTokenRequestDTO) {
        JSONObject requestJsonObject = new JSONObject((Object)fileTokenRequestDTO);
        return TangoUploadUtil.httpPost(BASE_URL + "/api/fileAccessToken", requestJsonObject);
    }

    public static ReturnWrapper<Map<String, Object>> directoryAccessToken(DirectoryTokenRequestDTO directoryRequestDTO) {
        JSONObject requestJsonObject = new JSONObject((Object)directoryRequestDTO);
        return TangoUploadUtil.httpPost(BASE_URL + "/api/directoryAccessToken", requestJsonObject);
    }

    public static ReturnWrapper<Map<String, Object>> tangoUploadFile(Map<String, Object> tokenMap, File file) {
        System.out.println("serverType:" + Integer.parseInt((String)tokenMap.get("serverType")));
        if (Integer.parseInt((String)tokenMap.get("serverType")) == 1) {
            return TangoUploadUtil.selfNodeUploadFile(tokenMap, file);
        }
        if (Integer.parseInt((String)tokenMap.get("serverType")) == 3) {
            try {
                FileInputStream input = new FileInputStream(file);
                return TangoUploadUtil.ossUploadFile(tokenMap, input, file.getName());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static ReturnWrapper<Map<String, Object>> tangoUploadFile(Map<String, Object> tokenMap, String stringUrl) {
        String fileName = stringUrl.substring(stringUrl.lastIndexOf("/") + 1, stringUrl.length());
        return TangoUploadUtil.tangoUploadFile(tokenMap, stringUrl, fileName);
    }

    public static ReturnWrapper<Map<String, Object>> tangoUploadFile(Map<String, Object> tokenMap, String stringUrl, String fileName) {
        try {
            return TangoUploadUtil.tangoUploadFile(tokenMap, new URL(stringUrl), fileName);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReturnWrapper<Map<String, Object>> tangoUploadFile(Map<String, Object> tokenMap, URL url) {
        String stringUrl = url.toString();
        String fileName = stringUrl.substring(stringUrl.lastIndexOf("/") + 1, stringUrl.length());
        return TangoUploadUtil.tangoUploadFile(tokenMap, url, fileName);
    }

    public static ReturnWrapper<Map<String, Object>> tangoUploadFile(Map<String, Object> tokenMap, URL url, String fileName) {
        System.out.println("serverType:" + Integer.parseInt((String)tokenMap.get("serverType")));
        if (Integer.parseInt((String)tokenMap.get("serverType")) == 1) {
            System.out.println("\u81ea\u5efa\u8282\u70b9\u6682\u4e0d\u652f\u6301");
            return null;
        }
        if (Integer.parseInt((String)tokenMap.get("serverType")) == 3) {
            try {
                InputStream input = url.openStream();
                return TangoUploadUtil.ossUploadFile(tokenMap, input, fileName);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static String getBaseUrl() {
        return BASE_URL;
    }

    public static void setBaseUrl(String baseUrl) {
        BASE_URL = baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileByFilePath(Map<String, Object> tokenMap, String filePath) {
        URL url = null;
        OSSClient ossClient = null;
        if (!(StringUtils.isEmpty((String)((String)tokenMap.get("accessKeyId"))) || StringUtils.isEmpty((String)((String)tokenMap.get("accessKeySecret"))) || StringUtils.isEmpty((String)((String)tokenMap.get("securityToken"))))) {
            ossClient = new OSSClient((String)tokenMap.get("endpoint"), (String)tokenMap.get("accessKeyId"), (String)tokenMap.get("accessKeySecret"), (String)tokenMap.get("securityToken"));
        } else {
            System.out.println("\u9a8c\u8bc1\u4fe1\u606f\u5f02\u5e38");
        }
        try {
            Date expiration = new Date(new Date().getTime() + 3600000L);
            String bucketName = (String)tokenMap.get("bucket");
            url = ossClient.generatePresignedUrl(bucketName, filePath, expiration);
        }
        catch (Exception exception) {
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return url.toString();
    }

    public static String readFileById(ReadFileRequestDTO readFileRequestDto) {
        JSONObject jsonRequest = new JSONObject((Object)readFileRequestDto);
        String resp = HttpRequestUtil.postRequeset(BASE_URL + "/api/readFile", jsonRequest.toString());
        JSONObject jsonResp = new JSONObject(resp);
        if ((Integer)jsonResp.get("code") == 0) {
            return (String)jsonResp.getJSONObject("data").get("fileUrl");
        }
        return null;
    }

    private static String getFileName(String fileUrl) {
        String str = "aliyuncs.com/";
        int beginIndex = fileUrl.indexOf(str);
        if (beginIndex == -1) {
            return null;
        }
        return fileUrl.substring(beginIndex + str.length());
    }

    private static ReturnWrapper<Map<String, Object>> httpPost(String url, JSONObject request) {
        ReturnWrapper<Map<String, Object>> returnWrapper = new ReturnWrapper<Map<String, Object>>();
        String resp = HttpRequestUtil.postRequeset(url, request.toString());
        if (StringUtils.isEmpty((String)resp)) {
            returnWrapper.setCode(-1);
            returnWrapper.setMessage("\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5");
            return returnWrapper;
        }
        JSONObject respJsonObejct = null;
        try {
            respJsonObejct = new JSONObject(resp);
        }
        catch (Exception e) {
            returnWrapper.setCode(-1);
            returnWrapper.setMessage("\u8fd4\u56de\u5185\u5bb9\u65e0\u6cd5\u8f6c\u6210JSON\u683c\u5f0f");
            return returnWrapper;
        }
        returnWrapper = new ReturnWrapper();
        returnWrapper.setCode((Integer)respJsonObejct.get("code"));
        returnWrapper.setMessage((String)respJsonObejct.get("message"));
        if ((Integer)respJsonObejct.get("code") == 0) {
            returnWrapper.setData(respJsonObejct.getJSONObject("data").toMap());
        }
        return returnWrapper;
    }

    private static ReturnWrapper<Map<String, Object>> selfNodeUploadFile(Map<String, Object> param, File file) {
        try {
            return HttpRequestUtil.postFile((String)param.get("endpoint"), param, file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ReturnWrapper<Map<String, Object>> ossUploadFile(Map<String, Object> requestDTO, InputStream input, String fileName) {
        ReturnWrapper<Map<String, Object>> returnWrapper = new ReturnWrapper<Map<String, Object>>();
        JSONObject responseDto = new JSONObject();
        String url = null;
        OSSClient ossClient = null;
        String uuid = null;
        if (StringUtils.isEmpty((String)((String)requestDTO.get("fileId")))) {
            uuid = CommonUtil.getUUID();
        }
        if (!(StringUtils.isEmpty((String)((String)requestDTO.get("accessKeyId"))) || StringUtils.isEmpty((String)((String)requestDTO.get("accessKeySecret"))) || StringUtils.isEmpty((String)((String)requestDTO.get("securityToken"))))) {
            ossClient = new OSSClient((String)requestDTO.get("endpoint"), (String)requestDTO.get("accessKeyId"), (String)requestDTO.get("accessKeySecret"), (String)requestDTO.get("securityToken"));
        } else {
            System.out.println("\u9a8c\u8bc1\u4fe1\u606f\u5f02\u5e38");
        }
        String ossFullPathName = "";
        try {
            if (((String)requestDTO.get("mappingPath")).startsWith("/")) {
                ossFullPathName = ((String)requestDTO.get("mappingPath")).substring(1, ((String)requestDTO.get("mappingPath")).length());
            }
            if (ossFullPathName.endsWith("*")) {
                ossFullPathName = ossFullPathName.substring(0, ossFullPathName.length() - 1);
            }
            if (StringUtils.isEmpty((String)((String)requestDTO.get("fileId")))) {
                ossFullPathName = ossFullPathName + fileName;
            }
            System.out.println("upload ossFullPathName:" + ossFullPathName);
            PutObjectRequest putObjectRequest = new PutObjectRequest((String)requestDTO.get("bucket"), ossFullPathName, input);
            putObjectRequest.setCallback(TangoUploadUtil.buildCallback(requestDTO, CommonUtil.getSuffix(fileName), uuid));
            try {
                ossClient.putObject(putObjectRequest);
            }
            catch (OSSException oe) {
                oe.printStackTrace();
                ReturnWrapper<Map<String, Object>> returnWrapper2 = null;
                return returnWrapper2;
            }
            finally {
                ossClient.shutdown();
            }
            url = TangoUploadUtil.getFileUrl((String)requestDTO.get("endpoint"), (String)requestDTO.get("bucket"), ossFullPathName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)((String)requestDTO.get("fileId")))) {
            responseDto.put("fileId", (Object)uuid);
        } else {
            responseDto.put("fileId", (Object)((String)requestDTO.get("fileId")));
        }
        responseDto.put("filePath", (Object)ossFullPathName);
        responseDto.put("fileUrl", (Object)TangoUploadUtil.readFileByFilePath(requestDTO, ossFullPathName));
        if (StringUtils.isNotEmpty((String)((String)responseDto.get("fileUrl")))) {
            returnWrapper.setCode(0);
            returnWrapper.setMessage("\u64cd\u4f5c\u6210\u529f");
            returnWrapper.setData(responseDto.toMap());
            return returnWrapper;
        }
        returnWrapper.setCode(-1);
        returnWrapper.setMessage("\u4e0a\u4f20\u5931\u8d25");
        return returnWrapper;
    }

    private static Callback buildCallback(Map<String, Object> requestDTO, String suffix, String uuid) {
        Callback callback = new Callback();
        callback.setCallbackUrl((String)((Map)requestDTO.get("callback")).get("callbackUrl"));
        callback.setCallbackHost(((String)requestDTO.get("endpoint")).replace("https://", ""));
        if (StringUtils.isNotEmpty((String)suffix) && imageSuffix.contains(suffix)) {
            callback.setCallbackBody((String)((Map)requestDTO.get("callback")).get("imageCallbackBody"));
        } else {
            callback.setCallbackBody((String)((Map)requestDTO.get("callback")).get("fileCallbackBody"));
        }
        callback.setCalbackBodyType(Callback.CalbackBodyType.JSON);
        if (StringUtils.isEmpty((String)((String)requestDTO.get("fileId")))) {
            callback.addCallbackVar("x:var1", uuid);
        } else {
            callback.addCallbackVar("x:var1", (String)requestDTO.get("fileId"));
        }
        callback.addCallbackVar("x:var2", (String)requestDTO.get("mappingPath"));
        return callback;
    }

    private static String getFileUrl(String endPotion, String bucketName, String fileName) {
        return endPotion.replaceFirst("https://", "https://" + bucketName + ".") + "/" + fileName;
    }
}

