/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.amqp.message.callback;

import com.hundsun.amqp.message.callback.TickMessasge;
import com.hundsun.amqp.message.listener.MessageListenerAdapter;
import com.hundsun.mcapi.interfaces.ISubCallback;
import com.hundsun.mcapi.subscribe.MCSubscribeParameter;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MessageCallBack
implements ISubCallback,
ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private MessageListenerAdapter messageListenerAdapter;
    private MessageListenerAdapter tickMessageListenerAdapter;
    private static List<IEvent> msgListCache;
    private static List<TickMessasge> tickMsgListCache;
    private static byte[] msgLock;
    private static byte[] tickMsgLock;
    private static Log log;

    private void OnReceivedProx(String topicName, IEvent event) {
        if (this.messageListenerAdapter != null) {
            try {
                MessageConverter eventMessageConverter = this.messageListenerAdapter.getMessageConverter();
                this.messageListenerAdapter.onMessage(eventMessageConverter.toMessage((Object)event, null));
            }
            catch (Exception e) {
                throw new AmqpException((Throwable)e);
            }
        }
    }

    private void OnRecvTickMsgProx(TickMessasge tickMessasge) {
        if (this.tickMessageListenerAdapter != null) {
            try {
                MessageConverter simpleMessageConverter = this.tickMessageListenerAdapter.getMessageConverter();
                this.tickMessageListenerAdapter.onMessage(simpleMessageConverter.toMessage((Object)tickMessasge, new MessageProperties()));
            }
            catch (Exception e) {
                throw new AmqpException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void OnReceived(String topicName, IEvent event) {
        if (applicationContext != null) {
            MessageCallBack messageCallBack = (MessageCallBack)applicationContext.getBean(MessageCallBack.class);
            byte[] byArray = tickMsgLock;
            synchronized (tickMsgLock) {
                if (msgListCache.size() != 0) {
                    for (IEvent eventCache : msgListCache) {
                        messageCallBack.OnReceivedProx(null, eventCache);
                    }
                    msgListCache.clear();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                messageCallBack.OnReceivedProx(topicName, event);
                return;
            }
        }
        byte[] byArray = tickMsgLock;
        synchronized (tickMsgLock) {
            log.info((Object)"spring context is not started, the cache msg.");
            msgListCache.add(event);
            if (msgListCache.size() <= 1000) return;
            msgListCache.clear();
            throw new AmqpException("msgListCache too long!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void OnRecvTickMsg(MCSubscribeParameter param, String tickMsgInfo) {
        TickMessasge tickMessasge = new TickMessasge();
        tickMessasge.setInfo(tickMsgInfo);
        tickMessasge.setSubscribeParameter(param);
        if (applicationContext != null) {
            MessageCallBack messageCallBack = (MessageCallBack)applicationContext.getBean(MessageCallBack.class);
            byte[] byArray = msgLock;
            synchronized (msgLock) {
                if (tickMsgListCache.size() != 0) {
                    for (TickMessasge tickMessasgeCache : tickMsgListCache) {
                        messageCallBack.OnRecvTickMsgProx(tickMessasgeCache);
                    }
                    tickMsgListCache.clear();
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                messageCallBack.OnRecvTickMsgProx(tickMessasge);
                return;
            }
        }
        byte[] byArray = msgLock;
        synchronized (msgLock) {
            log.info((Object)"spring context is not started, the cache tickMessasge.");
            tickMsgListCache.add(tickMessasge);
            if (tickMsgListCache.size() <= 1000) return;
            tickMsgListCache.clear();
            throw new AmqpException("tickMsgListCache too long!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        applicationContext = arg0;
        MessageCallBack messageCallBack = (MessageCallBack)applicationContext.getBean(MessageCallBack.class);
        byte[] byArray = tickMsgLock;
        synchronized (tickMsgLock) {
            if (msgListCache.size() != 0) {
                for (IEvent eventCache : msgListCache) {
                    messageCallBack.OnReceivedProx(null, eventCache);
                }
                msgListCache.clear();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            byArray = msgLock;
            synchronized (msgLock) {
                if (tickMsgListCache.size() != 0) {
                    for (TickMessasge tickMessasgeCache : tickMsgListCache) {
                        messageCallBack.OnRecvTickMsgProx(tickMessasgeCache);
                    }
                    tickMsgListCache.clear();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    public MessageListenerAdapter getMessageListenerAdapter() {
        return this.messageListenerAdapter;
    }

    public void setMessageListenerAdapter(MessageListenerAdapter messageListenerAdapter) {
        this.messageListenerAdapter = messageListenerAdapter;
    }

    public MessageListenerAdapter getTickMessageListenerAdapter() {
        return this.tickMessageListenerAdapter;
    }

    public void setTickMessageListenerAdapter(MessageListenerAdapter tickMessageListenerAdapter) {
        this.tickMessageListenerAdapter = tickMessageListenerAdapter;
    }

    static {
        msgListCache = new ArrayList<IEvent>();
        tickMsgListCache = new ArrayList<TickMessasge>();
        msgLock = new byte[0];
        tickMsgLock = new byte[0];
        log = LogFactory.getLog(MessageCallBack.class);
    }
}

