/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.amqp.message.core;

import com.hundsun.amqp.message.interfaces.IAmqpTemplate;
import com.hundsun.mcapi.MCServers;
import com.hundsun.mcapi.subscribe.MCSubscribeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSAmqpAdmin
implements AmqpAdmin,
ApplicationContextAware,
InitializingBean {
    private IAmqpTemplate hsTemplate;
    private ApplicationContext applicationContext;

    public HSAmqpAdmin(IAmqpTemplate hsTemplate) {
        this.hsTemplate = hsTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public IAmqpTemplate getHsTemplate() {
        return this.hsTemplate;
    }

    public void declareBinding(Binding arg0) {
    }

    public void declareExchange(Exchange arg0) {
    }

    public Queue declareQueue() {
        return null;
    }

    public void declareQueue(Queue arg0) {
    }

    public boolean deleteExchange(String arg0) {
        return false;
    }

    public boolean deleteQueue(String arg0) {
        return false;
    }

    public void deleteQueue(String arg0, boolean arg1, boolean arg2) {
    }

    public Properties getQueueProperties(String arg0) {
        return null;
    }

    public void purgeQueue(String arg0, boolean arg1) {
    }

    public void removeBinding(Binding arg0) {
    }

    public void afterPropertiesSet() throws Exception {
        int ret = 0;
        try {
            Collection exchanges = this.filterDeclarables(this.applicationContext.getBeansOfType(Exchange.class).values());
            for (Exchange exchange : exchanges) {
                TopicExchange topicExchange = (TopicExchange)exchange;
                MCSubscribeParameter subParam = (MCSubscribeParameter)topicExchange.getArguments().get("subParam");
                if (subParam.GetTopicName() == null && topicExchange.getName() != null) {
                    subParam.SetTopicName(topicExchange.getName());
                }
                if ((ret = MCServers.GetSubscriber().SubscribeTopic(subParam, this.hsTemplate.getTimeout())) >= 0) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new AmqpException((Throwable)e);
        }
        if (ret < 0) {
            throw new AmqpException("ErrorNo=" + ret + " " + MCServers.GetErrorMsg((int)ret));
        }
    }

    private <T extends Declarable> Collection<T> filterDeclarables(Collection<T> declarables) {
        ArrayList<Declarable> filtered = new ArrayList<Declarable>();
        for (Declarable declarable : declarables) {
            Collection adminsWithWhichToDeclare = declarable.getDeclaringAdmins();
            if (!declarable.shouldDeclare() || !adminsWithWhichToDeclare.isEmpty() && !adminsWithWhichToDeclare.contains(this)) continue;
            filtered.add(declarable);
        }
        return filtered;
    }
}

