/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.amqp.message.core;

import com.hundsun.amqp.message.interfaces.IAmqpTemplate;
import com.hundsun.mcapi.MCServers;
import com.hundsun.mcapi.exception.MCException;
import com.hundsun.mcapi.exception.MCPublishException;
import com.hundsun.mcapi.exception.MCSubscribeException;
import com.hundsun.mcapi.util.MCFilter;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import org.springframework.amqp.AmqpException;

public class HSAmqpTemplate
implements IAmqpTemplate {
    private int timeout = 5000;
    private static final String DEFAULT_ROUTING_KEY = "";
    private String routingKey = "";

    public void convertAndSend(Object dataset) throws AmqpException {
        this.convertAndSend(this.routingKey, dataset);
    }

    public void convertAndSend(String routingKey, Object dataset) throws AmqpException {
        block4: {
            if (dataset instanceof IDataset) {
                try {
                    int ret = MCServers.GetPublisher().PubMsg(routingKey, (IDataset)dataset, this.getTimeout());
                    String errorMsg = "publisher msg error!";
                    if (ret != 0) {
                        errorMsg = MCServers.GetErrorMsg((int)ret);
                        throw new AmqpException("ErrorNo=" + ret + " " + errorMsg);
                    }
                    break block4;
                }
                catch (MCPublishException e) {
                    throw new AmqpException((Throwable)e);
                }
            }
            throw new AmqpException("HSAmqpTemplate convertAndSend Type only allows for the IDataset!");
        }
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public IDataset getTopics(boolean force) throws AmqpException {
        try {
            return MCServers.GetTopic((boolean)force, (int)this.timeout);
        }
        catch (T2SDKException e) {
            throw new AmqpException("getTopics error!", (Throwable)e);
        }
        catch (MCException e) {
            throw new AmqpException("getTopics error!", (Throwable)e);
        }
    }

    public IDataset getTopics() throws AmqpException {
        return this.getTopics(false);
    }

    public void cancelSubscribeTopic(String topicName, MCFilter mcFilter) throws AmqpException {
        try {
            int ret = MCServers.GetSubscriber().CancelSubscribeTopicEx(topicName, mcFilter);
            if (ret != 0) {
                throw new AmqpException("ErrorNo=" + ret + " " + MCServers.GetErrorMsg((int)ret));
            }
        }
        catch (MCSubscribeException e) {
            throw new AmqpException("cancelSubscribeTopic error!", (Throwable)e);
        }
    }

    static {
        T2Services server = T2Services.getInstance();
        try {
            server.init();
            server.start();
            MCServers.MCInit();
        }
        catch (T2SDKException e) {
            throw new AmqpException((Throwable)e);
        }
        catch (MCException e) {
            throw new AmqpException((Throwable)e);
        }
    }
}

