/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.amqp.message.listener;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MessageListenerAdapter
implements MessageListener {
    static final String DEFAULT_LISTENER_METHOD = "handleMessage";
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";
    private MessageConverter messageConverter;

    public MessageListenerAdapter(Object delegate) {
        this.delegate = delegate;
    }

    public MessageListenerAdapter(Object delegate, MessageConverter messageConverter) {
        this.delegate = delegate;
        this.messageConverter = messageConverter;
    }

    public MessageListenerAdapter(Object delegate, String defaultListenerMethod) {
        this(delegate);
        this.setDefaultListenerMethod(defaultListenerMethod);
    }

    protected Object extractMessage(Message message) throws AmqpException {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        throw new AmqpException("MessageConverter null error!");
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) throws Exception {
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments) throws Exception {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof IOException) {
                throw new AmqpIOException((IOException)targetEx);
            }
            throw new AmqpException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            ArrayList<String> arrayClass = new ArrayList<String>();
            if (arguments != null) {
                for (int i = 0; i < arguments.length; ++i) {
                    arrayClass.add(arguments[i].getClass().toString());
                }
            }
            throw new AmqpException("Failed to invoke target method '" + methodName + "' with argument type = [" + StringUtils.collectionToCommaDelimitedString(arrayClass) + "], value = [" + ObjectUtils.nullSafeToString((Object[])arguments) + "]", ex);
        }
    }

    public void onMessage(Message message) {
        try {
            Object delegate = this.getDelegate();
            if (delegate != this && delegate instanceof MessageListener) {
                ((MessageListener)delegate).onMessage(message);
                return;
            }
            Object convertedMessage = this.extractMessage(message);
            String methodName = this.getListenerMethodName(message, convertedMessage);
            if (methodName == null) {
                throw new AmqpIllegalStateException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
            }
            Object[] listenerArguments = this.buildListenerArguments(convertedMessage);
            Object result = this.invokeListenerMethod(methodName, listenerArguments);
        }
        catch (Exception e) {
            throw new AmqpException((Throwable)e);
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }
}

